# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
import time

from cbb.business.operate.expansion import common
from cbb.frame.base import funcUtils
from cbb.frame.context import contextUtil
from cbb.frame.cli import cliUtil

# 界面展示的进度总时间
UI_PROGRESS_TIME_SECS = 30 * 60
# 实际检查的超时时间
FACT_CHECK_TIME_SECS = 40 * 60


@funcUtils.fakeProgress(UI_PROGRESS_TIME_SECS)
def execute(context):
    """扩控后检查硬盘框运行状态是否为Online

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        lang = contextUtil.getLang(context)
        result_dict = {"flag": True, "errMsg": "", "suggestion": ""}

        query_flag = True
        smart_abnormal_list = list()
        sas_abnormal_list = list()
        start_time = time.time()
        while time.time() - start_time <= FACT_CHECK_TIME_SECS:
            query_flag, smart_abnormal_list, sas_abnormal_list = \
                check_status(context)
            # 所有智能框都正常后停止轮询
            if query_flag and not smart_abnormal_list:
                break
            # 超过界面显示时间后，在界面刷新提示信息
            if time.time() - start_time >= UI_PROGRESS_TIME_SECS:
                context["remindInfo"] = common.getRes(
                    lang, "smart.enclosure.sync.version")
            time.sleep(5)

        abnormal_list = smart_abnormal_list + sas_abnormal_list
        # 直到超时都查询失败或存在异常状态的硬盘框，则不通过
        if not query_flag or abnormal_list:
            result_dict["flag"] = False
            result_dict["errMsg"], result_dict["suggestion"] = \
                common.getMsg(lang, "disk.enclosure.abnormal",
                              errMsgArgs=", ".join(abnormal_list))
            contextUtil.handleFailure(context, result_dict)
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return
    except Exception as ex:
        contextUtil.handleException(context, ex)
        logger.logException(ex)
        return
    finally:
        context["remindInfo"] = ""


def check_status(context):
    """检查硬盘框运行状态

    :param context: 上下文
    :return:
    """
    lang = contextUtil.getLang(context)
    cli = contextUtil.getCli(context)
    smart_abnormal_list = list()
    sas_abnormal_list = list()

    cmd = r"show enclosure"
    cli_ret = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if cli_ret[0] is not True:
        return False, smart_abnormal_list, sas_abnormal_list

    enc_infos = cliUtil.getHorizontalCliRet(cli_ret[1])
    for enc_info in enc_infos:
        enc_id = enc_info.get("ID", "")
        enc_type = enc_info.get("Type", "").lower()
        running_status = enc_info.get("Running Status", "")
        # 状态online的框直接跳过
        if running_status == "Online":
            continue
        # 不为online的智能框
        if "smart" in enc_type or "ip" in enc_type:
            smart_abnormal_list.append(enc_id)
        # 不为online的普通框
        elif "disk" in enc_type:
            sas_abnormal_list.append(enc_id)

    return True, smart_abnormal_list, sas_abnormal_list
