# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion.scm import check_expand_scm
from cbb.frame.context import contextUtil
from cbb.frame.cli import cliUtil
from cbb.business.operate.expansion import common


def execute(context):
    """
    智能缓存池扩引擎检查
    :param context: context
    :return:
    """
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    flag, _, err_msg = check_expand_scm.execute(
        cli, lang, logger, context, check_type="expansion")
    logger.logInfo("flag={}, err_msg={}".format(flag, err_msg))
    if not flag:
        suggestion = cliUtil.getMsg(lang, "expand.cache.pool.not.pass")
        result_dict = {"flag": False, "errMsg": err_msg,
                       "suggestion": suggestion}
        contextUtil.handleFailure(context, result_dict)
        return
    contextUtil.handleSuccess(context)
