# -*- coding: UTF-8 -*-

from cbb.business.operate.checkitems import check_memory_type
from cbb.frame.checkitem.context_adapter import ExpansionContext
from cbb.frame.checkitem.base_dsl_check import CheckStatus
from cbb.frame.context import contextUtil


def execute(context):
    """
    检查内存类型
    @param context: 上下文
    """
    expansion_context = ExpansionContext(context)
    check_result, _ = \
        check_memory_type.execute(expansion_context.get_context())
    if check_result.get("flag") in [CheckStatus.PASS, CheckStatus.NO_SUPPORT]:
        contextUtil.handleSuccess(context)
        return
    contextUtil.handleFailure(context, check_result)
