# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.base import baseUtil
from cbb.business.collect.products_adapter import compare_version

SWITCH = "switch"
INNER_METRO_EXP_CTRL_LIMIT = 8


def execute(context):
    """
    功能描述：检查内双活license
    接口:
    修改记录:
    """
    CheckInnerHyperMetroLicense(context).execute_check()


class CheckInnerHyperMetroLicense:
    def __init__(self, context):
        """
        功能描述：初始化信息
        参数：context
        返回值：
        异常描述：
        修改记录：
        """
        self.logger = common.getLogger(context.get("logger"), __file__)
        self.result_dict = {"flag": True, "errMsg": "", "suggestion": ""}
        self.lang = contextUtil.getLang(context)
        self.context = context
        self.product_model = contextUtil.getItem(context, "productModel")
        self.product_version = contextUtil.getItem(context, "productVersion")
        self.new_config_clust_type = contextUtil.getItem(context,
                                                         "newConfigClustType")
        self.has_inner_metro = contextUtil.getItem(context,
                                                   "hasInnerMetroLicense")
        self.new_config_ctrl_num = contextUtil.getItem(context, "newConfigCtrlNum")
        self.logger.logInfo(
            "new_config_clust_type: {},has_inner_metro: {}".format(
                self.new_config_clust_type, self.has_inner_metro))

    def execute_check(self):
        """
        功能描述：检查项入口，执行检查逻辑
        参数：
        返回值：
        异常描述：
        修改记录：
        """
        # Dorado V6高端，存在内双活，交换机组网，检查不通过
        if all([self.new_config_clust_type == SWITCH,
                self.has_inner_metro,
                self.is_risk_model()]):
            self.result_dict["flag"] = False
            self.result_dict["errMsg"], self.result_dict["suggestion"] = \
                common.getMsg(
                    self.lang, "innerhypermetro.license.not.support.switch")
            contextUtil.handleFailure(self.context, self.result_dict)
            return
        self.logger.logInfo("exp_controller_num:{}.".format(self.new_config_ctrl_num))
        if self.has_inner_metro and self.new_config_ctrl_num > INNER_METRO_EXP_CTRL_LIMIT:
            self.logger.logInfo("exp_controller_num:{} over limit.".format(self.new_config_ctrl_num))
            self.result_dict["flag"] = False
            self.result_dict["errMsg"], self.result_dict["suggestion"] = \
                common.getMsg(self.lang, "innerhypermetro.license.switch.limit.ctrl.num")
            contextUtil.handleFailure(self.context, self.result_dict)
            return

        contextUtil.handleSuccess(self.context)
        return

    def is_risk_model(self):
        """
        功能描述：检查是否为风险版本,X系列高端不支持，高端V6版本低于6.1.5RC1的交换组网。
        参数：
        返回值：Dorado V6高端版本低于6.1.5RC1返回 True,否则返回False
        异常描述：
        修改记录：
        """
        if baseUtil.is_ocean_protect_high(self.product_model):
            return True
        if baseUtil.isDoradoV6HighEnd(self.product_model) and compare_version(self.product_version, "6.1.5RC1") < 0:
            return True
        return False
