# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.expansion import common


def initData(context):
    """扩容完成界面

    :param context: 上下文
    :return:
    """
    logger = None
    # noinspection PyBroadException
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        # noinspection PyBroadException
        try:
            # 扩容完成后关闭AD进程，仅下发命令，不处理结果
            tlv = contextUtil.getTlv(context)
            adTlvUtil.stopAD(tlv)
        except Exception:
            logger.logInfo("Stop AD failure.")

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        if logger:
            logger.logException(exception)
        return

    finally:
        contextUtil.destroyTlvConnection(context)
        contextUtil.destroyCliConnection(context)
