# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvUtil

#进度总剩余时间
LIMIT_TIME = 60
#进度刷新间隔
INTERVAL = 2

def execute(context):
    '''
    @summary: 获取集群基本信息并保存到上下文对象中：
        ipVer: 原集群管理IP网络类型（区分ipv4/ipv6）
        originEnclosureSNs: 原集群所有框SN
        productModel: 产品型号
        productVersion: 产品版本
    '''
    
    try:
        #进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        #进度开始
        common.inProcess(context)
        
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        
        cli = contextUtil.getCli(context)
        if cli is None:
            logger.logNoPass("create cli connection failure")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "dev.conn.failure")
            contextUtil.handleFailure(context, resultDict)
            return
        
        tlv = contextUtil.getTlv(context)
        
        #获取原集群框SN
        originEnclosureSNs = tlvUtil.getEnclosureSNs(tlv)
        logger.logInfo("originEnclosureSNs:%s" % originEnclosureSNs)
        ctrl_enclosure_num = len(originEnclosureSNs)
        if len(originEnclosureSNs) == 0 or "" in originEnclosureSNs:
            resultDict["flag"] = False
            resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "enclosure.sn.null")
            contextUtil.handleFailure(context, resultDict)
            return
        
        #获取产品版本
        productVersion = tlvUtil.getProductVersion(tlv)
        logger.logInfo("productVersion:%s" % productVersion)
        
        #获取IP类型
        devObj = contextUtil.getDevObj(context)
        accessIP = devObj.get("ip")
        ipVer = common.getIpVer(accessIP)
        logger.logInfo("ipVer:%s" % ipVer)
        
        #保存原集群IP类型信息到上下文
        contextUtil.setItem(context, "ipVer", ipVer)
        #保存原集群所有框SN信息到上下文
        contextUtil.setItem(context, "originEnclosureSNs", originEnclosureSNs)
        #保存产品版本到上下文
        contextUtil.setItem(context, "productVersion", productVersion)

        # 当前系统组网方式，有交换机即为交换机组网
        new_cluster_type = contextUtil.getItem(
            context, "newConfigClustType")
        logger.logInfo("newConfigClustType:%s" % new_cluster_type)
        cluster_type = 1 if \
            (ctrl_enclosure_num > 1 and new_cluster_type == "switch") else 0
        logger.logInfo("configClustType:%s" % cluster_type)
        contextUtil.setItem(context, "configClustType", cluster_type)
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        #进度条刷为完成状态
        common.finishProcess(context)
        
