# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil

#进度总剩余时间
LIMIT_TIME = 60
#进度刷新间隔
INTERVAL = 2

def execute(context):
    '''
    @summary: 获取当前集群信息
    '''
    
    try:
        #进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        #进度开始
        common.inProcess(context)

        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)

        # 引擎内扩控转引擎间扩控时，清除标记
        contextUtil.removeItem(context, "newCtrlNum")
        tlv = contextUtil.getTlv(context)
        if tlv is None:
            logger.logNoPass("create rest connection failure")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "dev.conn.failure")
            contextUtil.handleFailure(context, resultDict)
            return
        
        #获取设备信息
        common.getClustInfo(context, tlv)
        
        controllerNum = contextUtil.getItem(context, "ctrlNum")
        bayConfigCtrlNum = contextUtil.getItem(context, "configCtrlNum")
        expansionSpecDict = contextUtil.getItem(context, "expansionSpecDict")
        bayConfigClustType = contextUtil.getItem(context, "configClustType")
        
        #判断当前集群控制器数量是否与配置文件中控制器数量一致
        if controllerNum < bayConfigCtrlNum:
            logger.logNoPass("Number of controllers is inconsistent")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "controllers.number.inconsistent")
            contextUtil.handleFailure(context, resultDict)
            return
        
        #判断当前组网方式是否支持扩容
        if expansionSpecDict is None:
            logger.logNoPass("Do not support expansion")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "donot.support.expansion")
            contextUtil.handleFailure(context, resultDict)
            return
        
        contextUtil.handleSuccess(context)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        #进度条刷为完成状态
        common.finishProcess(context)

