# -*- coding: UTF-8 -*-
from cbb.frame.base import baseUtil
from cbb.frame.base.config import HYBRID_V6_ENTRY_LEVEL_END
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.business.product.product_selector import get_product_adapter
from cbb.business.product.product_selector import init_product_adapter
from cbb.frame.checkitem.context_adapter import ExpansionContext
import os

# 5110E,5210E新增背板型号
NEW_LOW_END_ENHANCED_INTER_MODEL = [
    "5110ES_V5_16G_P", "5110ES_V5_P", "5210ES_V5_P", "5210ES_V5_32G_P"
]
# 新增低端短框5120V5,5220V5
NEW_LOW_END_ULTRA_MODEL = [
    "5120 V5", "5220 V5"
]

# 低端palm内部型号
LOW_END_PALM = ("5310N_V5", "5310FN_V5", "D5300V6_N_C", "D3000V6_N_C")

# OceanDisk 1600系列
OCEANDISK_1600 = ("OceanDisk 1600", "OceanDisk 1600T")

# OceanDisk 1500系列
OCEANDISK_1500 = ("OceanDisk 1500", "OceanDisk 1500T")
# 中端nvme内部型号。
MID_END_NVME = ("D5600V6_N_C_X", "D5600V6_N_C_X_1P")


def execute(context, param):
    """获取组网图链接地址

    :param context:
    :param param:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        lang = contextUtil.getLang(context)
        rootPath = contextUtil.getImportRootDir(context)
        newConfigClustType = contextUtil.getItem(context, "newConfigClustType")
        ctrlHeight = contextUtil.getItem(context, "ctrlHeight")
        newConfigCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
        productModel = contextUtil.getItem(context, "productModel")
        internal_model = contextUtil.getItem(context, "internalModel")
        # 5300 V6 NVME,3000 V6 NVME 获取内部型号字段为“interProductModel”
        inter_product_model = contextUtil.getItem(context, "interProductModel")
        if not internal_model:
            internal_model = inter_product_model

        # 先用新版本的逻辑查找资源，找不到在走老的查找逻辑
        doc_link = get_doc_link_by_adapter(context, param)
        if doc_link and os.path.exists(doc_link):
            context["doc_link"] = doc_link
            return

        if baseUtil.isDoradoDev(productModel):
            pdtType = "V6"
        else:
            pdtType = "V5"

        if baseUtil.isDoradoDev(productModel):
            pdt_type_switch = "V6"
        elif baseUtil.is_v5_middle_new(productModel):
            pdt_type_switch = "V5LOWMID"
        else:
            pdt_type_switch = "V5HIGH"

        network_diagram_identifier = get_network_diagram_identifier(internal_model, productModel)

        networkingDocPth = os.path.join(rootPath, "res", "html", "networking")
        if str(param) == "none_common":
            context["doc_link"] = os.path.join(
                rootPath, "res", "html", "networking", "insertNewCtrls",
                "networkOrg_%s.html" % lang)

        elif str(param) == "none_highDesity":
            context["doc_link"] = os.path.join(
                rootPath, "res", "html", "networking", "insertNewCtrls",
                "networkOrg_highDesity_%s.html" % lang)

        elif str(param) == "none_2800":
            context["doc_link"] = os.path.join(
                rootPath, "res", "html", "networking", "insertNewCtrls",
                "networkOrg_2800_%s.html" % lang)

        elif str(param) == "ipScaleOut":
            # 6800 V5组网图
            if productModel in config.PDT_MODEL_6800V5:
                context["doc_link"] = os.path.join(
                    rootPath, "res", "html", "networking", newConfigClustType,
                    "%sU%sC" % (ctrlHeight, newConfigCtrlNum), "v5",
                    "networkOrg_%s.html" % lang)
            else:
                context["doc_link"] = os.path.join(
                    rootPath, "res", "html", "networking", newConfigClustType,
                    "%sU%sC" % (ctrlHeight, newConfigCtrlNum),
                    "networkOrg_%s.html" % lang)

        elif str(param) == "pcieScaleOut":
            context["doc_link"] = os.path.join(
                rootPath, "res", "html", "networking", "pcieswitch",
                "%sU%sC" % (ctrlHeight, newConfigCtrlNum),
                "networkOrg_%s.html" % lang)

        elif str(param) == "restore":
            context["doc_link"] = os.path.join(
                rootPath, "res", "help", "restoreFactoryMode_%s_%s.chm" % (
                    pdtType, lang))
        elif str(param) == "hybrid_common":
            context["doc_link"] = os.path.join(rootPath, "res", "html",
                                               "networking", "hybrid",
                                               "networkOrg_%s.html" % lang)
        elif str(param) == "hybrid_highDesity":
            context["doc_link"] = os.path.join(
                rootPath, "res", "html", "networking", "hybrid",
                "networkOrg_highDesity_%s.html" % lang)
        elif str(param) == "hybrid_68V5":
            context["doc_link"] = os.path.join(
                rootPath, "res", "html", "networking", newConfigClustType,
                "%sU%sC" % (ctrlHeight, newConfigCtrlNum), "v5",
                "networkOrg_%s.html" % lang)
        elif str(param) == "splitCtrl":
            context["doc_link"] = os.path.join(
                rootPath, "res", "help",
                "restoringDualControllerConfiguration_%s.chm" % lang)
        elif str(param) == "switchInit":
            context["doc_link"] = os.path.join(
                rootPath, "res", "help", "switchesInitConfig_%s_%s.chm" %
                                         (pdt_type_switch, lang))
        elif str(param) == "manuallyConfigSwitch":
            context["doc_link"] = os.path.join(
                rootPath, "res", "help",
                "manuallyConfiguringSwitches_%s_%s.chm" % (pdt_type_switch,
                                                           lang))
        elif str(param) == "midAndLowEnd":
            context["doc_link"] = os.path.join(
                rootPath, "res", "html", "networking", newConfigClustType,
                "%sU%sC%s" % (ctrlHeight, newConfigCtrlNum, network_diagram_identifier),
                "networkOrg_%s.html" % lang)
        elif str(param) == "highEnd":
            net_work_org = get_ocean_protect_high_dev_net_work_org(internal_model) \
                if baseUtil.is_ocean_protect_high(productModel) \
                else "networkOrg_%s.html"
            context["doc_link"] = os.path.join(
                rootPath, "res", "html", "networking", newConfigClustType,
                "%sU%sC_%s" % (ctrlHeight, newConfigCtrlNum, pdtType),
                net_work_org % lang)
        elif str(param) == "startAd":
            context["doc_link"] = os.path.join(
                rootPath, "res", "help",
                "startAdProcess_%s_%s.chm" % (pdtType, lang))
        elif str(param) == "poweronController":
            context["doc_link"] = os.path.join(
                rootPath, "res", "help",
                "poweronController_%s_%s.chm" % (pdtType, lang))
        elif str(param) == "modifyPlaneOfSwitch":
            context["doc_link"] = os.path.join(
                rootPath, "res", "help", "modifyPlaneOfSwitch_%s.chm" % lang)

        # For Dorado18000 V3
        elif str(param) == "Dorado18000_4C":
            fourCtrlNetOrgHtmlPth = os.path.join(
                networkingDocPth, 'insertNewCtrls',
                'networkOrg_Dorado18000_%s.html' % lang)
            context["doc_link"] = fourCtrlNetOrgHtmlPth
        elif str(param) == "Dorado18000_pcie":
            originCtrlNum = contextUtil.getItem(context, "ctrlNum", 4)
            newCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum", 8)
            isDaeInGraph = (originCtrlNum, newCtrlNum) == (6, 8)
            ctrlNumDir = '6U%(newCtrlNum)sC' % {'newCtrlNum': newConfigCtrlNum}
            numCtrlNetOrgHtmlPth = os.path.join(
                networkingDocPth, 'pcieswitch', ctrlNumDir,
                'networkOrg_Dorado18000_%s%s.html' % (
                    'DAE_' if isDaeInGraph else '', lang))
            context["doc_link"] = numCtrlNetOrgHtmlPth
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def get_ocean_protect_high_dev_net_work_org(internal_model):
    """
    获取二级存储高端设备的组网图网页地址
    @param internal_model: 内部型号
    @return: 组网图网页地址
    """

    return "networkOrg_OceanProtect_nvme_%s.html" \
        if internal_model == "D6800V6_N_C_X" \
        else "networkOrg_OceanProtect_%s.html"


def get_network_diagram_identifier(internal_model, product_model):
    """
    获取组网图区分标识
    @param internal_model: 内部型号
    @param product_model: 设备型号
    @return: 组网图区分标识
    """
    # 低端短框，中端长框
    network_diagram_identifier = ""
    if baseUtil.is_micro_dev(product_model):
        network_diagram_identifier = get_ocean_disk_network_diagram_identifier(internal_model, product_model)
    elif baseUtil.isV5LowEndEnhanced(product_model):
        network_diagram_identifier = "_short_enhanced_base" \
            if internal_model in NEW_LOW_END_ENHANCED_INTER_MODEL or product_model in NEW_LOW_END_ULTRA_MODEL \
            else "_short_enhanced"
    # 新融合入门级和D2000/D2100组网图一致
    elif baseUtil.is_dorado_2000(product_model) or product_model in HYBRID_V6_ENTRY_LEVEL_END:
        network_diagram_identifier = "_short_base"
    elif is_low_end_palm(internal_model):
        network_diagram_identifier = "_short_palm"
    elif baseUtil.isV5V6LowEnd(product_model):
        network_diagram_identifier = "_short"
    elif internal_model in MID_END_NVME:
        network_diagram_identifier = "_long_palm"
    elif baseUtil.isV5V6MidEnd(product_model):
        network_diagram_identifier = "_long"
    return network_diagram_identifier


def get_ocean_disk_network_diagram_identifier(internal_model, product_model):
    """
    获取微存储组网图标识
    1600和1600T区分全闪和混闪，但组网图一样；1500和1500T组网图区分全闪和混闪
    :param internal_model: 内部型号
    :param product_model: 产品型号
    :return: 组网图标识
    """
    network_diagram_identifier = ""
    if product_model in OCEANDISK_1600:
        network_diagram_identifier = "_disk1600"
    elif product_model in OCEANDISK_1500:
        if baseUtil.is_micro_flashing_dev(internal_model):
            network_diagram_identifier = "_disk1500_hybrid"
        else:
            network_diagram_identifier = "_disk1500_flash"
    return network_diagram_identifier


def is_low_end_palm(internal_model):
    """
    判断是否为低端palm
    @param internal_model: 内部型号
    @return: 是：低端palm 否：并不是低端palm
    """
    for model in LOW_END_PALM:
        if model in internal_model:
            return True
    return False


def get_doc_link_by_adapter(context, param):
    expansion_context = ExpansionContext(context)
    init_product_adapter(expansion_context.get_context())
    product_adapter = get_product_adapter()
    if product_adapter:
        product_adapter.get_logger().info(
            "use product adapter cal expansion spec.")
        doc_link = product_adapter.get_doc_link(param)
        product_adapter.get_logger().info("doc_link={}".format(doc_link))
        return doc_link
    return ""
