# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.common.conf.productConfig import ENC_HEIGHT_TO_CTRL_NUM
from cbb.common.conf.productConfig import ORI_CTRL_TO_ENC_NUM
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion.scm.check_expand_scm \
    import check_need_expand_scm


def getItems(context):
    """获取扩容注意事项的内容

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        lang = contextUtil.getLang(context)

        ctrl_enclosure_height = contextUtil.getItem(context, "ctrlHeight")
        new_config_ctrl_num = contextUtil.getItem(context, "newConfigCtrlNum")
        controller_num = contextUtil.getItem(context, "ctrlNum")
        newConfigClustType = contextUtil.getItem(context, "newConfigClustType")

        makesure_items = []
        # 2U/3U
        if ctrl_enclosure_height in [2, 3]:
            makesure_items.append(common.getRes(lang, "notice_unpackage"))
            makesure_items.append(common.getRes(lang, "notice_unpoweron"))
            makesure_items.append(common.getRes(lang, "notice_advice"))
            makesure_items.append(common.getRes(lang, "notice_startAd"))
        # 4U/6U
        elif ctrl_enclosure_height in [4, 6]:
            # 单个引擎的最大控制器个数
            peer_ctrl_num = ENC_HEIGHT_TO_CTRL_NUM.get(ctrl_enclosure_height, 4)
            # 原集群未满配
            if controller_num % peer_ctrl_num != 0:
                # 仅插入控制器场景
                if (new_config_ctrl_num - controller_num) < peer_ctrl_num:
                    makesure_items.append(common.getRes(lang, "notice_unpackage_ctrl"))
                    makesure_items.append(common.getRes(lang, "notice_unpoweron_ctrl"))
                    makesure_items.append(common.getRes(lang, "notice_noexpension_ctrl"))
                # 混合场景
                else:
                    makesure_items.append(common.getRes(lang, "notice_unpackage"))
                    makesure_items.append(common.getRes(lang, "notice_unpoweron"))
                    makesure_items.append(common.getRes(lang, "notice_multiExpansions"))
                    makesure_items.append(common.getRes(lang, "notice_advice"))
                    makesure_items.append(common.getRes(lang, "notice_startAd"))
                # 提示拔出以太网卡
                ctrl_enc_num = ORI_CTRL_TO_ENC_NUM.get(controller_num)
                makesure_items.append(common.getRes(lang, "notice_eth_interface", ctrl_enc_num))
            # 原集群满配，直接加引擎
            else:
                makesure_items.append(common.getRes(lang, "notice_unpackage"))
                makesure_items.append(common.getRes(lang, "notice_unpoweron"))
                makesure_items.append(common.getRes(lang, "notice_advice"))
                makesure_items.append(common.getRes(lang, "notice_startAd"))

        if newConfigClustType == common.CLUST_TYPE_SWITCH:
            makesure_items.append(common.getRes(lang, "notice_scale_out_monopolize_switch"))

        if check_need_expand_scm(context):
            makesure_items.append(common.getRes(lang, "notice_expand_scm_disk"))

        makesure_items.append(common.getRes(lang, "notice_manage_ip_conflicts"))

        json_array = []
        for item in makesure_items:
            json_array.append('{"title":"%s"}' % item)
        context["retData"] = "[%s]" % ",".join(json_array)

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
