# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def refresh(context):
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        
        expansionSpecDict = contextUtil.getItem(context, "expansionSpecDict")
        defaultKey = common.getDefaultNetworkType(expansionSpecDict)
        
        curData = context["curData"]
        if common.getRes(lang, "none") in curData:
            defaultKey = common.CLUST_TYPE_NONE
            
        elif common.getRes(lang, "switch") in curData:
            defaultKey = common.CLUST_TYPE_SWITCH
            
        elif common.getRes(lang, "direct") in curData:
            defaultKey = common.CLUST_TYPE_DIRECT
        
        expansionSpec = expansionSpecDict.get(defaultKey)
        expansionCtrls = common.getExpansionCtrlsSpec(expansionSpec)
        
        ctrlNum = contextUtil.getItem(context, "ctrlNum")
        
        msg = common.getRes(lang, "controller")
        expansionCtrls = ["%s %s" % (str(num), msg) for num in expansionCtrls if num > ctrlNum]
        context["retData"] = '{"rule":"%s","default":"%s"}' % ("##".join(expansionCtrls), expansionCtrls[0])
        
        contextUtil.handleSuccess(context)
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return

def refreshBaseIp(context):
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        curData = context["curData"]
        ctrlNum = contextUtil.getItem(context, "ctrlNum")
        newCtrlNum = int(curData.split()[0])
        encHeight = contextUtil.getItem(context, "ctrlHeight")
        isShow = str(common.isNeedCofigIP(ctrlNum, newCtrlNum, encHeight))
        context["retData"] = '{"isShow":"%s"}' % isShow

        contextUtil.handleSuccess(context)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return