# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2022. All rights reserved.

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common


def refresh(context):
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        # 不具备容器特性，不需要更新
        if not contextUtil.getItem(context, "has_container_feature"):
            contextUtil.handleSuccess(context)
            return

        cur_data = context["curData"]
        logger.logInfo("cur_data: {}".format(cur_data))

        # 扩容后控制器数量
        new_config_ctrl_num = int(cur_data.split()[0])
        contextUtil.setItem(context, "new_ctrl_num", new_config_ctrl_num)
        logger.logInfo("new_config_ctrl_num: {}".format(new_config_ctrl_num))
        # 备份IP数量
        exist_backup_ip = contextUtil.getItem(context, "existing_backup_ip_num")
        # 需要的IP个数为控制器数量的2倍
        if common.get_required_backup_ip_num(context) >= exist_backup_ip:
            context["retData"] = '{"isShow":"True"}'
        else:
            context["retData"] = '{"isShow":"False"}'

        contextUtil.handleSuccess(context)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
