# -*- coding: UTF-8 -*-
import sys

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.frame.context import contextUtil
from cbb.frame.base import baseUtil
from cbb.frame.cli import cliUtil
from utils import Products

BACKUP = "backup"
ARCHIVE = "archive"
COPY = "copy"


def execute(context):
    '''
    @summary: 保存扩容组网方式和新控制器数量
    '''

    try:
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)

        # 系统字符编码
        reload(sys)
        sys.setdefaultencoding("utf-8")

        msg = common.getRes(lang, "controller")
        curData = context["curData"]

        # 设置新配置文件中集群组网方式
        netWorkingType = None
        if common.getRes(lang, "switch") in curData:
            netWorkingType = common.CLUST_TYPE_SWITCH
        elif common.getRes(lang, "direct") in curData:
            netWorkingType = common.CLUST_TYPE_DIRECT
        # 无阻网时视为直连组网（1、组网方式选择“不涉及” 时防呆，2、触发扩容接口下发参数中组网方式为直连）
        elif common.getRes(lang, "none") in curData:
            netWorkingType = common.CLUST_TYPE_DIRECT

        # 设置新配置文件中控制器数量
        curDataDict = common.jsonStr2Dict(curData)
        newBayConfigCtrlNum = int(curDataDict["networkSpec"].split()[0])

        contextUtil.setItem(context, "newConfigClustType", netWorkingType)
        logger.logInfo("newConfigClustType:%s" % netWorkingType)
        contextUtil.setItem(context, "newConfigCtrlNum", newBayConfigCtrlNum)
        logger.logInfo("newConfigCtrlNum:%s" % newBayConfigCtrlNum)

        # 大规格集群带容器扩容开关关闭时，不允许带容器服务扩容到2个引擎以上
        if not check_container_switch(context):
            contextUtil.setItem(context, "newConfigClustType", "")
            err_msg = common.getRes(lang, "not_support_exp_more_than_two_engine")
            contextUtil.handleFailure(context, {"flag": False, "errMsg": err_msg, "suggestion": ""})
            return

        # 当型号为A8000时，获取备份IP和归档IP
        if contextUtil.getItem(context, "productModel") == "OceanProtect A8000"\
                or contextUtil.getItem(context, "has_container_feature"):
            flag, err_msg = set_backup_and_archive_replication_ip(context, curDataDict)
            if not flag:
                # IP配置失败时，取消保存的组网方式，避免点击取消时继续走扩容流程
                contextUtil.setItem(context, "newConfigClustType", "")
                contextUtil.handleFailure(context, {"flag": False, "errMsg": err_msg, "suggestion": ""})
                return

        # 记录用户行为数据
        contextUtil.appendUserOpData(context, config.UserOpDataFields.EXPANSION_TYPE_CTRL)

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def set_backup_and_archive_replication_ip(context, cur_data_dict):
    """
    设置备份IP、归档IP和复制IP
    :param context:
    :param cur_data_dict:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    err_msg_list = []
    all_ip_num = []
    common.set_ip_to_list(contextUtil.getItem(context, "backup_start_ip"),
                          contextUtil.getItem(context, "backup_end_ip"), all_ip_num)
    # 不支持非连续网段
    if not contextUtil.getItem(context, "have_subnet"):
        backup_start_ip, backup_end_ip = get_ip_data_by_type(context, cur_data_dict)
        logger.logInfo("backup_start_ip:{},backup_end_ip:{}".format(
            backup_start_ip, backup_end_ip))

        # 备份IP不存在
        if not backup_start_ip and not backup_end_ip:
            return True, ""
        verify_ip(backup_start_ip, backup_end_ip, context, err_msg_list, BACKUP)
    # 支持非连续网段
    else:
        exist_backup_plane = contextUtil.getItem(context, "exist_backup_plane")
        if not exist_backup_plane:
            return True, ""
        exist_backup_ip_num = contextUtil.getItem(context, "existing_backup_ip_num")

        backup_start_ip_new, backup_end_ip_new = get_ip_data_by_type(context, cur_data_dict, is_new=True)
        common.set_ip_to_list(backup_start_ip_new, backup_end_ip_new, all_ip_num)
        logger.logInfo("backup_start_ip_new:{},backup_end_ip_new:{}".format(
            backup_start_ip_new, backup_end_ip_new))
        add_ip_num = common.get_ip_num(backup_start_ip_new, backup_end_ip_new)
        # 需要的IP个数为控制器数量(扩容后引擎数量大于2，控制器数量以两个引擎内控制器数量为准)的2倍
        required_num = common.get_required_backup_ip_num(context) if contextUtil.getItem(context, "has_container_feature") else 8
        # 存在备份IP配置框,有subnetMask字段，原始IP小于8个,需要先校验多段ip
        if int(exist_backup_ip_num) < int(required_num):
            flag, err_msg = common.check_multi_ips(exist_backup_plane, [backup_start_ip_new, backup_end_ip_new], context)
            if not flag:
                err_msg_list.append(err_msg)
            elif (exist_backup_ip_num + add_ip_num) < required_num:
                err_msg_list.append(common.getRes(lang, "backup_ip_not_enough"))

    check_archive_ip(context, cur_data_dict, err_msg_list, all_ip_num)
    check_copy_ip(context, cur_data_dict, err_msg_list, all_ip_num)
    set_list = set(all_ip_num)
    if not len(set_list) == len(all_ip_num):
        err_msg_list.append(common.getRes(lang, "ip_cannot_be_the_same"))
    if err_msg_list:
        contextUtil.setItem(context, "newConfigClustType", "")
        return False, "\n".join(err_msg_list)
    save_ip_data(context, cur_data_dict)
    return True, ""


def check_container_switch(context):
    """
    检查大规格带容器扩容开关（开关关闭时，不允许带容器服务扩容到2个引擎以上）
    @param context: 上下文
    @return: True: 通过 False： 不通过
    """
    product_model = contextUtil.getItem(context, "productModel")
    product_version = contextUtil.getItem(context, "productVersion")
    new_ctrl_num = contextUtil.getItem(context, "newConfigCtrlNum")
    # 二级存储不涉及,直接通过
    if baseUtil.is_ocean_protect(product_model):
        return True
    # 6.1.5以前没有容器开关
    if Products.compareVersion(product_version, "6.1.5") < 0:
        return True
    # 高端2引擎以内，直接通过
    if baseUtil.isDoradoV6HighEnd(product_model) and new_ctrl_num <= common.HIGH_END_WITH_TWO_ENGINE_CTRL_NUM:
        return True
    # 中端2引擎以内，直接通过
    if baseUtil.isDoradoV6Mid(product_model) and new_ctrl_num <= common.MID_END_WITH_TWO_ENGINE_CTRL_NUM:
        return True
    # 没有激活容器服务，直接通过
    if not has_container_service(context):
        return True
    # 检查开关是否打开
    return common.is_container_switch_open(context)


def has_container_service(context):
    """
    判断是否有容器服务
    @param context: 上下文
    @return: True: 有容器服务 False：没有容器服务
    """
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
    logger = contextUtil.getLogger(context)
    cmd = "show container_service general"
    try:
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if not flag:
            return True
        cli_ret_list = cli_ret.splitlines()
        container_service_status = ""
        for line in cli_ret_list:
            fields = line.split(":")
            if len(fields) < 2:
                continue

            field_name = fields[0].strip()
            field_value = fields[1].strip()

            if field_name == "Enabled":
                container_service_status = field_value
        return container_service_status == "On"
    except Exception as ex:
        # 默认容器服务未开启
        logger.info("get container service failed: {}".format(ex))
        return False


def save_ip_data(context, cur_data_dict):
    logger = context.get("logger")
    backup_start_ip, backup_end_ip = get_ip_data_by_type(context, cur_data_dict)
    # 只需要重新存储结束ip即可，因为开始ip不允许修改，一开始就必定存储了
    contextUtil.setItem(context, "backup_end_ip", backup_end_ip)
    backup_start_ip_new, backup_end_ip_new = get_ip_data_by_type(context, cur_data_dict, is_new=True)
    contextUtil.setItem(context, "backup_start_ip_new", backup_start_ip_new)
    contextUtil.setItem(context, "backup_end_ip_new", backup_end_ip_new)
    archive_start_ip, archive_end_ip = get_ip_data_by_type(context, cur_data_dict, ARCHIVE)
    contextUtil.setItem(context, "archive_end_ip", archive_end_ip)
    archive_start_ip_new, archive_end_ip_new = get_ip_data_by_type(context, cur_data_dict, ARCHIVE, True)
    contextUtil.setItem(context, "archive_start_ip_new", archive_start_ip_new)
    contextUtil.setItem(context, "archive_end_ip_new", archive_end_ip_new)
    copy_start_ip, copy_end_ip = get_ip_data_by_type(context, cur_data_dict, COPY)
    contextUtil.setItem(context, "copy_end_ip", copy_end_ip)
    copy_start_ip_new, copy_end_ip_new = get_ip_data_by_type(context, cur_data_dict, COPY, True)
    contextUtil.setItem(context, "copy_start_ip_new", copy_start_ip_new)
    contextUtil.setItem(context, "copy_end_ip_new", copy_end_ip_new)
    logger.info(
        "{}: {}-{},{}-{}".format(COPY, copy_start_ip, copy_end_ip, copy_start_ip_new, copy_end_ip_new))
    logger.info(
        "{}: {}-{},{}-{}".format(BACKUP, backup_start_ip, backup_end_ip, backup_start_ip_new, backup_end_ip_new))
    logger.info(
        "{}: {}-{},{}-{}".format(ARCHIVE, archive_start_ip, archive_end_ip, archive_start_ip_new, archive_end_ip_new))


def check_copy_ip(context, cur_data_dict, err_msg_list, all_ip_num):
    """
    检查复制IP
    :param context: 上下文
    :param cur_data_dict: 输入框数据
    :param err_msg_list: 错误信息列表
    :param all_ip_num: ip列表
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    common.set_ip_to_list(contextUtil.getItem(context, "copy_start_ip"),
                          contextUtil.getItem(context, "copy_end_ip"), all_ip_num)
    # 不支持非连续网段
    if not contextUtil.getItem(context, "have_subnet"):
        copy_start_ip, copy_end_ip = get_ip_data_by_type(context, cur_data_dict, COPY)
        logger.logInfo("copy_start_ip:{},copy_end_ip:{}".format(
            copy_start_ip, copy_end_ip))

        if not copy_start_ip and not copy_end_ip:
            return
        verify_ip(copy_start_ip, copy_end_ip, context,
                  err_msg_list, COPY)
        common.set_ip_to_list(copy_start_ip, copy_end_ip, all_ip_num)
        return
    # 支持非连续网段
    exist_copy_plane = contextUtil.getItem(context, "exist_copy_plane")
    if not exist_copy_plane:
        return
    exist_copy_ip_num = contextUtil.getItem(context,
                                               "existing_copy_ip_num")
    copy_start_ip_new, copy_end_ip_new = get_ip_data_by_type(
        context, cur_data_dict, data_type=COPY, is_new=True)
    logger.logInfo("copy_start_ip_new:{},copy_end_ip_new:{}".format(
        copy_start_ip_new, copy_end_ip_new))
    common.set_ip_to_list(copy_start_ip_new, copy_end_ip_new, all_ip_num)
    add_ip_num = common.get_ip_num(copy_start_ip_new, copy_end_ip_new)
    # 存在复制IP配置框,有subnetMask字段，原始IP小于4个,必定存在
    if exist_copy_ip_num < 4:
        flag, err_msg = common.check_multi_ips(exist_copy_plane,
                                               [copy_start_ip_new, copy_end_ip_new], context,
                                               plane_type=COPY)
        if not flag:
            err_msg_list.append(err_msg)
        elif (exist_copy_ip_num + add_ip_num) < 4:
            err_msg_list.append(common.getRes(lang, "copy_ip_not_enough"))


def check_archive_ip(context, cur_data_dict, err_msg_list, all_ip_num):
    """
    检查归档IP
    :param context: 上下文
    :param cur_data_dict: 输入框数据
    :param err_msg_list: 错误信息列表
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    common.set_ip_to_list(contextUtil.getItem(context, "archive_start_ip"),
                          contextUtil.getItem(context, "archive_end_ip"), all_ip_num)
    # 不支持非连续网段
    if not contextUtil.getItem(context, "have_subnet"):
        archive_start_ip, archive_end_ip = get_ip_data_by_type(context, cur_data_dict, ARCHIVE)
        logger.logInfo("archive_start_ip:{},archive_end_ip:{}".format(
            archive_start_ip, archive_end_ip))

        if not archive_start_ip and not archive_end_ip:
            return
        verify_ip(archive_start_ip, archive_end_ip, context,
                  err_msg_list, ARCHIVE)
        common.set_ip_to_list(archive_start_ip, archive_end_ip, all_ip_num)
        return
    # 支持非连续网段
    exist_archive_plane = contextUtil.getItem(context, "exist_archive_plane")
    if not exist_archive_plane:
        return
    exist_archive_ip_num = contextUtil.getItem(context,
                                               "existing_archive_ip_num")
    archive_start_ip_new, archive_end_ip_new = get_ip_data_by_type(
        context, cur_data_dict, data_type=ARCHIVE, is_new=True)
    common.set_ip_to_list(archive_start_ip_new, archive_end_ip_new, all_ip_num)
    logger.logInfo("archive_start_ip_new:{},archive_end_ip_new:{}".format(
        archive_start_ip_new, archive_end_ip_new))
    add_ip_num = common.get_ip_num(archive_start_ip_new, archive_end_ip_new)
    # 存在归档IP配置框,有subnetMask字段，原始IP小于4个,必定存在
    if exist_archive_ip_num < 4:
        flag, err_msg = common.check_multi_ips(exist_archive_plane,
                                               [archive_start_ip_new, archive_end_ip_new], context,
                                               plane_type=ARCHIVE)
        if not flag:
            err_msg_list.append(err_msg)
        elif (exist_archive_ip_num + add_ip_num) < 4:
            err_msg_list.append(common.getRes(lang, "archive_ip_not_enough"))


def get_ip_data_by_type(context, cur_data_dict, data_type=BACKUP, is_new=False):
    start_key = "{}_start_ip".format(data_type)
    end_key = "{}_end_ip".format(data_type)
    if is_new:
        start_key = "{}_start_ip_new".format(data_type)
        end_key = "{}_end_ip_new".format(data_type)
    start_ip_new = cur_data_dict.get(start_key)
    if not start_ip_new:
        start_ip_new = contextUtil.getItem(context, start_key)
    end_ip_new = cur_data_dict.get(end_key)
    if not end_ip_new:
        end_ip_new = contextUtil.getItem(context, end_key)
    return start_ip_new, end_ip_new


def verify_ip(archive_start_ip_new, archive_end_ip_new, context, err_msg_list, plane_type):
    flag, err_msg = common.verify_ip_address(
        context, archive_start_ip_new, archive_end_ip_new, plane_type)
    if not flag:
        err_msg_list.append(err_msg)


def executeIpConfig(context):
    '''
    @summary: 保存扩容组网方式和新控制器数量
    '''

    try:
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)

        # 系统字符编码
        reload(sys)
        sys.setdefaultencoding("utf-8")

        curData = context["curData"]

        # 设置新配置文件中控制器数量
        curDataDict = common.jsonStr2Dict(curData)
        logger.logInfo("modify base ipAddr curDataDict:%s" % curDataDict)
        configBaseIpAddr = str(curDataDict.get("modifyBaseIP", ""))

        if configBaseIpAddr != contextUtil.getItem(context, "selectedBaseIpAddr"):
            dialogUtil = context["dialogUtil"]
            remindParam = config.REMIND_INNER_IP.get(configBaseIpAddr)
            rec = dialogUtil.showWarningDialog(common.getMsg(lang, "warning.remind.innerip.collide", remindParam)[0])
            if not rec:
                resultDict = {"flag": True, "errMsg": "", "suggestion": ""}
                resultDict["flag"] = False
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "warning.choice.innerip")
                contextUtil.handleFailure(context, resultDict)
                return

        contextUtil.setItem(context, "selectedBaseIpAddr", configBaseIpAddr)
        contextUtil.setItem(context, "configBaseIpAddr", configBaseIpAddr)
        # 用于判断点击确定按钮
        contextUtil.setItem(context, "modifyBaseIpAddr", configBaseIpAddr)
        logger.logInfo("modify base ipAddr:%s" % configBaseIpAddr)

        # 记录用户行为数据
        contextUtil.appendUserOpData(context, config.UserOpDataFields.EXPANSION_TYPE_CTRL)

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
