# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.rest.restUtil import Tlv2Rest
from cbb.frame.rest import restData
from cbb.business.operate.expansion import common
from cbb.frame.cli import cliUtil
from cbb.frame.base import baseUtil
import time
from java.lang import Exception as JException
#检查控制器状态间隔 
CHECK_INTERVAL = 5

#检查PCIe链路
CHECK_PCIE_TIME = 2.5 * 60

#单个控制器复位时间
PER_CTRL_TIME = 45 * 60

#等待控制器重启了之后再查下
WAIT_REBOOT_TIME = 5 * 60

#执行入口
def execute(context):
    """
    @summary: 检查PCIe链路，如果PCIe链路错误，则需要重启备控进行修复，只涉及Dorado6000 V3 V300R001C01
    """
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        #初始化进度
        totalReaminTime = PER_CTRL_TIME + 2 * CHECK_PCIE_TIME
        contextUtil.setItem(context, "totalReaminTime", totalReaminTime)
        context["curRemainTime"] = totalReaminTime
        common.setExpansionProgress(context, True)
        
        
        productModel = contextUtil.getItem(context, "productModel")
        fullProductVersion = contextUtil.getItem(context, "fullProductVersion")
        if productModel != "Dorado6000 V3" or fullProductVersion != "V300R001C01SPC100":
            logger.logInfo("The current device is not involed:%s %s" %(productModel,fullProductVersion))
            contextUtil.handleSuccess(context)
            return 

        #PCIe链路检查，检查不通过再重启控制器，检查通过或出错直接返回
        context["remindInfo"] = common.getRes(lang, "pcielink_check")
        pcieLink = PCIeLink(context)
        checkPcieLinkRet = pcieLink.checkPcieLink(context)
        if checkPcieLinkRet in [CheckStatus.PASS, CheckStatus.ERROR]:
            return 
        
        context["curRemainTime"] = PER_CTRL_TIME + CHECK_PCIE_TIME
        common.setExpansionProgress(context, True)
        #获取备控
        pcieLink.getSlaveCtrl(context)
        
        #重启备控
        context["remindInfo"] = common.getRes(lang, "pcielink_reboot",pcieLink.rebootCtrl)
        rebootRet = pcieLink.rebootController(context)
        if rebootRet[0] != True:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = rebootRet[2]
            contextUtil.handleFailure(context, resultDict)
            return  
        
        #检查是否重启成功
        checkCtrlRet = pcieLink.checkCtrlStatus(context)
        if checkCtrlRet["flag"] != True:
            contextUtil.handleFailure(context, checkCtrlRet)
            return
        
        #PCIe链路验证
        context["remindInfo"] = common.getRes(lang, "pcielink_verify",pcieLink.rebootCtrl)
        context["curRemainTime"] = CHECK_PCIE_TIME
        common.setExpansionProgress(context, True)
        pcieLink.checkPcieLink(context)
        return
     
    except (Exception, JException), exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    
    finally:
        context["curRemainTime"] = 0
        common.setExpansionProgress(context, True)
        context["remindInfo"] = ""

class CheckStatus():
    PASS = 0
    PCIE_NOTPASS = 1
    ERROR = 2
    
class PCIeLink():  
    
    def __init__(self,context):
        self.logger = common.getLogger(context.get("logger"), __file__)
        self.lang = contextUtil.getLang(context)
        self.dev = contextUtil.getDevObj(context)
        self.rebootCtrl = ""
        
    def checkPcieLink(self, context):
        '''
        @summary: 检查PCIe链路
        '''
        resultDict = {"flag":True, "errMsg":"", "suggestion":"", "ret":""}
        rest = contextUtil.getRest(context)
        
        msgType = restData.Enum.UpdMsgTypeEnum.PRECHECK
        pkgType = 1
        cmd = restData.DaignoseCmd.CHECK_PCIELINK
        recs = Tlv2Rest.executeUpgProcess(rest, msgType, pkgType,restData.Enum.UpdActiveType.ONLINE, diagCmd = cmd)
        
        for rec in recs:
            nodeId = Tlv2Rest.getRecordValue(rec, restData.Upgrade.RecordParam.RECORD_NODE_ID)
            result = Tlv2Rest.getRecordValue(rec, restData.Upgrade.RecordParam.RECORD_RESULT)
            self.logger.logInfo("check pcie result, nodeId:%s, ret:%s" % (nodeId, result))  
            
            #只检查PCIE链路，GE链路不检查,False,FALSE:ETH:都为GE链路的返回
            if result in ["True","False"] or "FALSE:ETH:" in result:
                continue
            
            if result == "FALSE:Pcie":
                resultDict["flag"] = False
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(self.lang, "PcieSingleLinkCheck.pcieError")
                contextUtil.handleFailure(context, resultDict)
                return CheckStatus.PCIE_NOTPASS
            
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(self.lang, "PcieSingleLinkCheck.error")
            contextUtil.handleFailure(context, resultDict)
            return CheckStatus.ERROR
        
        contextUtil.handleSuccess(context)
        return CheckStatus.PASS
    
    def getSlaveCtrl(self,context):
        '''
        @summary: 获取备控，用于重启控制器
        '''
        cli = contextUtil.getCli(context)
        cmd = "show controller general |filterColumn include columnList=Controller,Role"
        cliRet = cliUtil.execCmdInCliMode(cli, cmd, True, self.lang)
        self.logger.logInfo("get controller result:%s" %unicode(cliRet))
        if cliRet[0] != True:
            return ""
        
        ctrlInfoList = cliUtil.getVerticalCliRet(cliRet[1])
        for ctrlInfo in ctrlInfoList:
            ctrlId = ctrlInfo.get("Controller")
            role = ctrlInfo.get("Role")
            if role == "Slave":
                self.rebootCtrl = ctrlId
                return ctrlId
        return ""
             
    def rebootController(self, context):
        '''
        @summary: 重启控制器
        ''' 
        if "" == self.rebootCtrl:
            msg = common.getMsg(self.lang, "cannot.get.controller.info")
            return (False,"", msg)
        
        cliRet = ""
        isOpened = False
        cmd = "reboot controller controller=%s" %self.rebootCtrl
        cli = contextUtil.getCli(context)
        try:
            isOpened, checkRet = cliUtil.needOpenDeveloperSwitch(cli, self.lang)

            if isOpened == True:
                checkRet = cliUtil.openDeveloperSwitch(cli, self.lang)
                if checkRet[0] != True:
                    return checkRet  
                    
            enterDeveloperCheckRet = cliUtil.enterDeveloperMode(cli, self.lang)
            if not enterDeveloperCheckRet[0]:
                cliUtil.developerMode2CliMode(cli)
                return enterDeveloperCheckRet
        
            checkRet = cliUtil.execCmdInCliMode(cli, cmd, False, self.lang)
            cliRet = checkRet[1]
            
            # 需要确认直接输入y
            ret = cliRet
            while "y/n" in ret:
                ret = cli.execCmd("y")
                cliRet += ret
                
            if "Password:" in cliRet:
                cliRet += cli.execCmdNoLog(self.dev.get("pawd"))
            
            if "Command executed successfully" in cliRet:
                self.logger.logInfo("execute reboot controller[%s] successfully" %self.rebootCtrl)
                return (True, cliRet, "")
            
            self.logger.logInfo("execute reboot controller[%s] fail" %self.rebootCtrl)
            return (False, cliRet, common.getMsg(self.lang, "reboot.ctrl.fail" , self.rebootCtrl))
                   
        finally:
            
            if cliUtil.isInDeveloperMode(cliRet):
                cliUtil.developerMode2CliMode(cli)
            #关闭开关
            if isOpened == True :
                cliUtil.closeDeveloperSwitch(cli, self.lang)
    
    def checkCtrlStatus(self, context):
        '''
        @summary: 检查控制器是否重启成功
        '''
        result = {"flag":True, "errMsg":"", "suggestion":"", "ret":""}
        
        startTime = time.clock()
        while (time.clock() - startTime) < PER_CTRL_TIME:
            try:
                #等待重启命令生效
                if (time.clock() - startTime) < WAIT_REBOOT_TIME:
                    continue
                
                cli = contextUtil.getCli(context)
                ctrlRet = cliUtil.getCtrlInfoById(cli, self.rebootCtrl, self.lang)
                if ctrlRet[0] != True:
                    continue
               
                ctrlInfo = ctrlRet[1]
                healthStatus = ctrlInfo.get("Health Status")
                runningStatus = ctrlInfo.get("Running Status")
                if healthStatus == "Normal" and runningStatus == "Online":
                    return result
                break
            except (Exception, JException),e:
                self.logger.logInfo("check controller exception:%s" %unicode(e))
                continue
            finally:
                baseUtil.safeSleep(CHECK_INTERVAL)
                context["curRemainTime"] -= CHECK_INTERVAL
                common.setExpansionProgress(context, True)
                
        result["flag"] = False    
        result["errMsg"], result["suggestion"] = common.getMsg(self.lang, "reboot.ctrl.fail", self.rebootCtrl)
        return result     
