
# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def execute(context):
    '''
    @summary: judge whether exist disk domain or not
    '''

    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)
        
        
        #judge whether exist disk domain or not
        checkDiskDomainRet = common.isExistDiskDomain(cli, lang)
        logger.logInfo("checkDiskDomainRet:%s"%checkDiskDomainRet[1])
        if not checkDiskDomainRet[0]:
            logger.logNoPass("Cannot get controller info")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "cannot.get.controller.info")
            contextUtil.handleFailure(context, resultDict)
            return
        if checkDiskDomainRet[3]:
            logger.logNoPass("Do not support expansion, because exist storage pool")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "exist.diskDomain.donot.support.expansion")
            contextUtil.handleFailure(context, resultDict)
            return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return