# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.expansion import FuncFactory


@FuncFactory.handleFailureForRetry
def execute(context):
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        
        #检查待扩控制器上是否存在特定告警,当前仅支持2扩4场景，如需支持8控场景需要把newBoardList按引擎号分开，一次只能对一个引擎进行修改
        newBoardsList = contextUtil.getItem(context, "newBoardsList")
        allProcess = 100.0
        endProcess = 0
        beginProcess = 0
        for board in newBoardsList:
            tlv = contextUtil.getTlv(context)
            flag, conflictAlarmList = adTlvUtil.checkManIPConflictAlarm(tlv,board)
            conflictAlarmList.sort(lambda x,y:common.cmpIPAlarmDict(x,y))
            if not flag:
                logger.logInfo("System exists manageIP conflict alarms")
                for portInfo in conflictAlarmList:
                    allProcess = allProcess/2
                    endProcess += allProcess
                    logger.logInfo("allProcess:%s  endProcess:%s  beginProcess:%s"%(allProcess,endProcess,beginProcess))
                    logger.logInfo("modify port ip:%s" %unicode(portInfo))
                    resultDict["flag"] = False
                    resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "error.unconfig.manip")
                    contextUtil.handleFailure(context,resultDict) 
                    
                    contextUtil.setItem(context, "MODIFY_MGMT_IP_INFO", portInfo) #作为修改端口ip的参数
                    
                    ipVer = common.IPV4 if common.isIpV4(portInfo["portIp"]) else common.IPV6
                    logger.logInfo("modify port ipver:%s" %unicode(ipVer))
                    contextUtil.setItem(context, "MODIFY_MGMT_IPVer", ipVer) #记录需要修改的IP类型
                    
                    contextUtil.setItem(context, "MODIFY_MGMT_BOARD", board) #记录需要修改的IP节点
                    
                    common.popupManIPConfigDialog(context, board, portInfo)
                    if context["succ"] == False:
                        resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "error.unconfig.manip")
                        contextUtil.handleFailure(context,resultDict)
                        return
                    common.sleepWithProcess(context, beginProcess, endProcess, common.CHECK_CONFLICT_LIMIT_TIME)
                    isExistConflictAlarm, alarm = adTlvUtil.checkConflictRecovery(tlv, board, portInfo)
                    logger.logInfo("check conflict recovery result:%s" %str(alarm))
                    if isExistConflictAlarm:
                        beginProcess = endProcess
                        continue
                    else:
                        resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "check.conflict.recovery.failed",portInfo["portLocation"])
                        contextUtil.handleFailure(context,resultDict)
                        return
                        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return