# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.frame.rest import restUtil
from cbb.frame.rest import restData
from cbb.frame.detect import detectUtil
from cbb.frame.context import contextUtil
from cbb.frame.base import baseUtil
from cbb.frame.tlv import tlvUtil
from cbb.frame.tlv import tlvData
import time

#在检查告警前需要等待一段时间(7分钟)
MGMT_PORT_ALARM_TIME = 7*60

#判断管理网口连接异常的告警ID
MGMT_PORT_ALARM_ID = '0xF00060007'

def execute(context):
    '''
    @summary: 检查端口连接正确性
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        common.setExpSucNotice(context)
        cli = contextUtil.getCli(context)
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        engineNum = str(len(tlvUtil.getEngineNameList(tlv)))
        ctrlHeight = contextUtil.getItem(context, "ctrlHeight")        
        
        # 剩余时间总数
        totalReaminTime = int(MGMT_PORT_ALARM_TIME) + 10
        curRemainTime = totalReaminTime
        contextUtil.setItem(context, "totalReaminTime", totalReaminTime)
        # 设置剩余时间
        context["curRemainTime"] = curRemainTime
        # 设置进度
        common.setExpansionProgress(context, True)

        #检查系统状态健康状态和运行状态是否正常
        checkSystemStatusRetDict = common.checkSystemStatus(cli, lang)
        if not checkSystemStatusRetDict["flag"]:
            logger.logNoPass("System status is abnormal")
            contextUtil.handleFailure(context, checkSystemStatusRetDict)
            return
        
        #获取所有的ETH端口信息
        tlv = contextUtil.getTlv(context)
        if not common.isNVMeDev(contextUtil.getItem(context, "ctrlEnclosureModel")):
            portLocationConfig = detectUtil.MGMT_PORT_CONFIG_FOR_DORADO.get("%sU" % ctrlHeight,{}).get(engineNum,[])
        else:
            portLocationConfig = detectUtil.MGMT_PORT_CONFIG_FOR_DORADO.get("%sU_NVMe" % ctrlHeight,{}).get(engineNum,[])
        portsinfoList = tlvUtil.getScaleOutPortsInfo(tlv,portLocationConfig)        
                
        #judge the ETH port whether link up           
        for portInfo in portsinfoList:
            location = portInfo["location"]
            runningStatus = portInfo["runningStatus"]
            if location in portLocationConfig and runningStatus == tlvData.RUNNING_STATUS_E["LINK_UP"]:
                portLocationConfig.remove(location)
                
        if len(portLocationConfig) > 0:
            logger.logNoPass("The link down ports list is : %s" % str(portLocationConfig))
            resultDict["flag"] = False
            resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "port.running.status.abnormal.dorado", 
                    ",".join(portLocationConfig))
            contextUtil.handleFailure(context, resultDict)
            return

        timeBeginToSleep = time.clock()
        #睡眠3.5分钟后查询是否有管理端口连接异常告警
        waitedTime = time.clock()- timeBeginToSleep
        while waitedTime < MGMT_PORT_ALARM_TIME:
            baseUtil.safeSleep(10)
            curRemainTime = totalReaminTime - waitedTime
            context["curRemainTime"]= curRemainTime 
            common.setExpansionProgress(context, True)
            waitedTime = time.clock() - timeBeginToSleep

        #查告警
        tlv = contextUtil.getTlv(context)
        alarmList = tlvUtil.getSystemAlarm(tlv)
        for alarm in alarmList:
            alarmID = alarm["CMO_ALARM_ID"]
            if alarmID == MGMT_PORT_ALARM_ID:
                logger.logNoPass("Management cables are not correctly.")
                resultDict["flag"] = False
                resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "Mgmt.cables.connect.wrong")
                contextUtil.handleFailure(context, resultDict)
                return
        
        #删除交换机默认管理IP
        
        #执行扩控后继承元阵列管理IP
        
        context["curProgressPer"] = 100    
        baseUtil.safeSleep(2)
        context.remove("curProgressPer")        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    
    finally:
        context["remindInfo"] = ""
        context["curRemainTime"] = 0
        common.setExpansionProgress(context, True)

def modifyPCIEMgmtIP(context):
    resultDict = {"flag":True, "errMsg":"", "suggestion":""}
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    
    #C00的TR5版本不支持删除交换机默认管理IP
    fullProductVersion = contextUtil.getItem(context, "fullProductVersion")
    spcVersion = common.getSPCVersion(fullProductVersion)
    if spcVersion in config.NO_SUPPORT_DELETE_SWTICH_IP:
        return True
    
    rest = contextUtil.getRest(context)
    ethPorts = restUtil.CommonRest.getEthPortsRecord(rest)
    logger.logInfo("ETH ports Ret:%s"%str(ethPorts))
    swithMgsPortsList = restUtil.CommonRest.getEthPortsListByLoc(ethPorts,"DSW.*.MGMT.0")
    logger.logInfo("The swith Mgs Ports List is :%s"%str(swithMgsPortsList))
    
    paramDict = {
                 restData.RestCfg.ModifyEthPortInfo.IPV4ADDR["index"]:"" ,
                 restData.RestCfg.ModifyEthPortInfo.IPV4MASK["index"]:"" ,
                 }
    for portDict in swithMgsPortsList:
        portId = portDict.get("id")
        flag = restUtil.CommonRest.modifyEthInfo(rest, portId, paramDict)
        if not flag:
            logger.logNoPass("Do not support expansion, because modify PCIE swith managment port failed.")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "modify.PCIE.swith.mgmtIp.failed")
            contextUtil.handleFailure(context, resultDict)
            return False
    
    return True

# todo 待删除
def inheritClusterMgtIP(context):
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        productModel = contextUtil.getItem(context, "productModel")
        
        #NEED_INHERIT_CLUSTER_MGTIP列表中的版本执行以下操作
        fullProductVersion = contextUtil.getItem(context, "fullProductVersion")
        spcVersion = common.getSPCVersion(fullProductVersion)
        if not common.isDorado(productModel):
            return True
        if spcVersion < config.NEED_INHERIT_CLUSTER_MGTIP_BASE_VERSION:
            return True
        tlv = contextUtil.getTlv(context)
        controllerNum = contextUtil.getItem(context, "ctrlNum")
        #执行管理IP继承命令
        tlvUtil.executeInheritClusterMgtIP(tlv,controllerNum)
    except Exception as exception:
        logger.logException(exception)
        logger.logNoPass("Inherit the management IP of a cluster failed.")
        resultDict["flag"] = False
        resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "inherit.cluster.mgt.ip.failed")
        contextUtil.handleFailure(context, resultDict)
        return False

    return True