# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import FuncFactory
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil


@FuncFactory.handleFailureForRetry
def execute(context):
    '''
    @summary: 检查端口连接正确性
    '''
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        newBoardsList = contextUtil.getItem(context, "newBoardsList")
        ctrlEnclosureModel = contextUtil.getItem(context, "ctrlEnclosureModel")
        for board in newBoardsList:
            newEncModel = adTlvUtil.getCtrlEncModel(tlv, board, logger)
            logger.logInfo("get new enclosure type:%s" %str(newEncModel))
            if newEncModel is None:
                continue
            
            if newEncModel != ctrlEnclosureModel:
                logger.logNoPass("ctrl enclosure type inconsistent(%s), old type:%s, new type:%s" % (str(board), str(ctrlEnclosureModel), str(newEncModel)))
                resultDict["flag"] = False
                resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "ctrlEncConsistent.ctrl.enclosure.inconsistent", board["enclosureSN"])
                contextUtil.handleFailure(context, resultDict)
                return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    
