# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import FuncFactory
from expandCtrl.script.common.check_exp_product_model_hybrid \
    import CheckNewPdtModelForHybrid
from expandCtrl.script.common.check_exp_product_model_solid \
    import CheckNewPdtModelForSolid
from cbb.frame.context import contextUtil
from cbb.frame.base import config


@FuncFactory.handleFailureForRetry
def execute(context):
    """检查待扩容控制器产品型号是否和原集群一致

    :param context: 上下文
    :return:
    """
    product_model = contextUtil.getItem(context, "productModel")
    if common.isDorado(product_model) or product_model in config.OCEAN_PROTECT:
        check_item = CheckNewPdtModelForSolid(context)
    else:
        check_item = CheckNewPdtModelForHybrid(context)
    return check_item.execute()
