# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import FuncFactory
from cbb.frame.context import contextUtil
from cbb.frame.base import config

from expandCtrl.script.doradoExpansion.preCheckMgmtCable import MgmtCheckItem
from expandCtrl.script.doradoExpansion.preCheckInnerHyperMetroPorts \
    import InnerHyperMetroPortsCheckItem

# 进度总剩余时间
LIMIT_TIME = 300
# 进度刷新间隔
INTERVAL = 2


@FuncFactory.handleFailureForRetry
def execute(context):
    """扩容前线缆连接正确性检查

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        # 进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        # 进度开始
        common.inProcess(context)
        pass_flag = True

        # 扩控前线缆检查
        mgmt_check = MgmtCheckItem(context)
        mgmt_check.execute()
        if mgmt_check.is_failed():
            logger.logInfo("check mgmt cable failed.")
            pass_flag = False

        # 微存储不支持内双活需屏蔽
        if contextUtil.getItem(context, "productModel") in config.OCEAN_STOR_MICRO_DEVS:
            if not pass_flag:
                contextUtil.handleFailure(context, mgmt_check.get_result_dict())
                return
            contextUtil.handleSuccess(context)
            logger.logPass()
            return

        # 内双活端口连接正确性检查
        inner_hyper_metro_check = InnerHyperMetroPortsCheckItem(context)
        flag = inner_hyper_metro_check.execute()
        if not flag:
            logger.logInfo("check inner hyper metro ports failed.")
            pass_flag = False

        if not pass_flag:
            result_dict = merge_result_dict(
                mgmt_check.get_result_dict(),
                inner_hyper_metro_check.get_result_dict())
            contextUtil.handleFailure(context, result_dict)
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        # 进度条刷为完成状态
        common.finishProcess(context)


def merge_result_dict(one, another):
    """合并两个结果

    :param one: result_dict
    :param another: result_dict
    :return: 合并后的结果
    """
    result_dict = {"flag": True, "errMsg": "", "suggestion": ""}

    result_dict["flag"] = one.get("flag") and another.get("flag")
    result_dict["errMsg"] = merge_message_string(
        one.get("errMsg"), another.get("errMsg"))
    result_dict["suggestion"] = merge_message_string(
        one.get("suggestion"), another.get("suggestion"))

    return result_dict


def merge_message_string(one, another):
    """合并消息字符串

    :param one: 字符串1
    :param another: 字符串2
    :return: 合并后的字符串
    """
    total = []
    if one:
        total.append(one)
    if another:
        total.append(another)
    return "\n".join(total)
