# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.frame.base import config
from cbb.frame.rest.restUtil import CommonRestService
from cbb.business.operate.expansion import common
from cbb.frame.tlv import adTlvUtil
from utils import Products

PRO_VERSION = "6.1.2RC1"
CONTAINER_SPEC = "0"


def execute(context):
    """
    检查容器使能类型
    :param context:
    :return:
    """

    try:
        result_dict = {"flag": True, "errMsg": "", "suggestion": ""}
        err_msg_list = []
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        tlv = contextUtil.getTlv(context)
        rest = contextUtil.getRest(context)
        original_version = contextUtil.getItem(context, "productVersion")
        product_model = contextUtil.getProductModel(context)
        if Products.compareVersion(original_version, PRO_VERSION) < 0 or \
                product_model not in config.DORADO_DEVS_V6:
            contextUtil.handleSuccess(context)
            return
        uri = "get_device_global_config"
        data = CommonRestService.get(rest, uri)
        if data.get("containerSpec") == CONTAINER_SPEC:
            contextUtil.handleSuccess(context)
            return
        new_boards_list = contextUtil.getItem(context, "newBoardsList")
        for board in new_boards_list:
            sn = board.get("enclosureSN")
            pdt_version, _ = adTlvUtil.getProductVersion(tlv, board)
            if Products.compareVersion(pdt_version, PRO_VERSION) < 0:
                err_msg, result_dict["suggestion"] = common.\
                    getMsg(lang, "expdd.check.container.spec.err",
                           (sn, pdt_version))
                err_msg_list.append(err_msg)
        if err_msg_list:
            result_dict["flag"] = False
            result_dict["errMsg"] = "\n".join(list(set(err_msg_list)))
            contextUtil.handleFailure(context, result_dict)
            return
        contextUtil.handleSuccess(context)
        return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
