# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

from cbb.business.operate.expansion import common
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.base import funcUtils
from cbb.frame.context import contextUtil
from cbb.frame.rest import restUtil
from cbb.frame.rest import restData
from cbb.common.query.hardware.enclosure import get_all_disk_enc_list

# 进度总剩余时间
LIMIT_TIME = 300
# 进度刷新间隔
INTERVAL = 5


@funcUtils.fakeProgress(totalSecs=LIMIT_TIME, intervalSec=INTERVAL)
def execute(context):
    """检查原集群硬盘框状态

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    result = {"flag": True, "errMsg": "", "suggestion": ""}
    try:
        lang = contextUtil.getLang(context)
        # 查询原集群中所有硬盘框信息
        ori_disk_enc = get_all_disk_enc_list(context)
        logger.logInfo("disk enclosure on origin sys:%s" % ori_disk_enc)

        # 查询原集群中所有级联板信息
        ori_exp_board = FuncFactory.getFruListInfo(
            context, restData.Enum.ObjEnum.EXPBOARD)
        logger.logInfo("exp_board on origin sys:%s" % ori_exp_board)

        fault_enc_list, fault_exp_board_list = check_status(ori_disk_enc,
                                                            ori_exp_board)
        # 错误消息
        enc_err_msg = exp_enc_err_msg = ""
        if fault_enc_list:
            result["flag"] = False
            enc_err_msg = common.getRes(lang, "disk.enclosure.fault",
                                        ",".join(fault_enc_list))
        if fault_exp_board_list:
            result["flag"] = False
            exp_enc_err_msg = common.getRes(lang, "exp.board.fault.enclosure",
                                            ",".join(fault_exp_board_list))
        # 不通过时，构造错误消息和修复建议
        if result.get("flag") is False:
            result["errMsg"] = "%s\n%s" % (enc_err_msg, exp_enc_err_msg)
            result["suggestion"] = common.getRes(
                lang, "exp.enclosure.check.suggestion")
            contextUtil.handleFailure(context, resultDict=result)
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def check_status(ori_disk_enc, ori_exp_board):
    """检查系统中硬盘框状态，以及硬盘框上级联板状态，返回异常的硬盘框列表

    :param ori_disk_enc: 当前系统中硬盘框信息
    :param ori_exp_board: 当前系统中级联板信息
    :return:
    """
    # 本身状态不正常的硬盘框列表
    fault_enc_list = []
    # 框上状态不正常或不在位的级联板
    fault_exp_board_list = []
    for disk_enc in ori_disk_enc:
        disk_enc_id = restUtil.Tlv2Rest.getRecordValue(
            disk_enc, restData.Hardware.Enclosure.ID)
        disk_enc_name = restUtil.Tlv2Rest.getRecordValue(
            disk_enc, restData.Hardware.Enclosure.NAME)
        enc_heal_sta = restUtil.Tlv2Rest.getRecordValue(
            disk_enc, restData.Hardware.Enclosure.HEALTH_STATUS)
        enc_run_sta = restUtil.Tlv2Rest.getRecordValue(
            disk_enc, restData.Hardware.Enclosure.RUNNING_STATUS)
        if enc_heal_sta != restData.Enum.HealthStatusEnum.NORMAL \
                or enc_run_sta != restData.Enum.RunningStatusEnum.ONLINE:
            fault_enc_list.append(disk_enc_name)
        # 框上所有级联板
        enc_exp_board = list(map(lambda x: "%s.%s" % (disk_enc_name, x),
                                 ["A", "B"]))
        for exp_board in ori_exp_board:
            exp_board_loc = restUtil.Tlv2Rest.getRecordValue(
                exp_board, restData.Hardware.Expboard.LOCATION)
            parent_id = restUtil.Tlv2Rest.getRecordValue(
                exp_board, restData.Hardware.Expboard.PARENT_ID)
            exp_board_heal_sta = restUtil.Tlv2Rest.getRecordValue(
                exp_board, restData.Hardware.Expboard.HEALTH_STATUS)
            exp_board_run_sta = restUtil.Tlv2Rest.getRecordValue(
                exp_board, restData.Hardware.Expboard.RUNNING_STATUS)
            if parent_id == disk_enc_id \
                    and exp_board_heal_sta == \
                    restData.Enum.HealthStatusEnum.NORMAL \
                    and exp_board_run_sta == \
                    restData.Enum.RunningStatusEnum.RUNNING:
                enc_exp_board.remove(exp_board_loc)
        fault_exp_board_list.extend(enc_exp_board)
    return fault_enc_list, fault_exp_board_list
