# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import adTlvUtil
from cbb.frame.tlv import tlvData

# IOM1和IOM3槽位
IOM1 = "IOM1"
IOM3 = "IOM3"

# 前端容器卡和后端容器卡的SRVICEMODE
CONTAINER_FRONT_END = "6"
CONTAINER_BACK_END = "7"

result_dict = {"flag": True, "errMsg": "", "suggestion": ""}


def execute(context):
    """
    检查新扩容控制器容器卡数量正常
    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    tlv = contextUtil.getTlv(context)
    try:
        # 获取待扩节点
        new_boards_list = contextUtil.getItem(context, "newBoardsList")

        # 获取IOM1和IOM3槽位的接口卡信息
        container_card_list = list()
        for board in new_boards_list:
            container_card_list.extend(get_container_card(tlv, board))

        logger.logInfo("container_card_list: {}".format(container_card_list))
        # 判断IOM1和IOM3槽位是否都插入了接口卡
        if len(new_boards_list) * 2 != len(container_card_list):
            process_err_info(context, lang, "card.type.not.match")
            return
        flag, err_status_card_list = \
            get_err_container_card_location(container_card_list)
        if not flag:
            process_err_info(context, lang, "card.type.not.match")
            return

        if err_status_card_list:
            process_err_info(context, lang, "card.status.abnormal",
                             ",".join(err_status_card_list))
            return

        contextUtil.handleSuccess(context)
        return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def process_err_info(context, lang, meg_key, card_location=""):
    result_dict["flag"] = False
    result_dict["errMsg"], result_dict["suggestion"] = \
        common.getMsg(lang, meg_key, card_location)
    contextUtil.handleFailure(context, result_dict)


def get_container_card(tlv, board):
    """
    获取节点上的容器卡
    :param tlv:
    :param board:
    :return:
    """
    records = adTlvUtil.getInterfaceModuleRecords(tlv, board)
    if not records:
        return []
    container_card_list = list()
    added_loc = list()
    for record in records:
        location = adTlvUtil.getRecordValue(record,
                                            tlvData.PUB_ATTR['location'])
        service_mode = adTlvUtil.getRecordValue(
            record, tlvData.INTF_MODULE['servicemode'])
        health_status = adTlvUtil.getRecordValue(
            record, tlvData.INTF_MODULE['healthStatus'])
        running_status = adTlvUtil.getRecordValue(
            record, tlvData.INTF_MODULE['runningStatus'])
        if all([location not in added_loc,
                (IOM1 in location or IOM3 in location)]):
            container_card_info = dict()
            container_card_info["location"] = location
            container_card_info["service_mode"] = service_mode
            container_card_info["health_status"] = health_status
            container_card_info["running_status"] = running_status
            container_card_list.append(container_card_info.copy())
            added_loc.append(location)
    return container_card_list


def get_err_container_card_location(container_card_list):
    """
    获取状态不正常的容器卡location
    :param container_card_list:
    :return: True，[] : 表示都位容器卡，且状态正常
             True, 非空列表：表示都为容器卡，但是存在容器卡状态异常
             False []: 表示IOM1或IOM3槽位存在非容器卡
    """
    err_status_card_list = list()
    for container_card in container_card_list:
        location = container_card.get("location", "")
        service_mode = str(container_card.get("service_mode", ""))
        health_status = container_card.get("health_status", "")
        running_status = container_card.get("running_status", "")
        # 判断IOM1或IOM3是否为容器卡
        if any([IOM1 in location and service_mode != CONTAINER_FRONT_END,
                IOM3 in location and service_mode != CONTAINER_BACK_END]):
            return False, err_status_card_list
        # 检查卡状态是否正常
        if health_status != tlvData.HEALTH_STATUS_E['NORMAL'] or \
                running_status != tlvData.RUNNING_STATUS_E['RUNNING']:
            err_status_card_list.append(location)
    return True, err_status_card_list
