# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from expandCtrl.script.doradoExpansion import setInnterIpCheckCollide


def saveData(context):
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    configBaseIpAddr = contextUtil.getItem(context, "configBaseIpAddr")
    backupConfigBaseIpAddr = contextUtil.getItem(context, "backupConfigBaseIpAddr")
    logger.logInfo("Saving configBaseIpAddr")

    if not common.isScaleOutExpansioned(backupConfigBaseIpAddr):
        configBaseIpAddr = context["input_configBaseIPScaleOut_chooseBaseIP"]
        contextUtil.setItem(context, "configBaseIpAddr", configBaseIpAddr)

    dialogUtil = context["dialogUtil"]
    setInnterIpCheckCollide.execute(context)
    if not context["succ"]:
        logger.logInfo("inner ip colided.")
        return

    if not common.isScaleOutExpansioned(backupConfigBaseIpAddr):
        remindParam = config.REMIND_INNER_IP.get(configBaseIpAddr)
        rec = dialogUtil.showWarningDialog(common.getMsg(lang, "warning.remind.innerip", remindParam)[0])
        if not rec:
            resultDict = {"flag": True, "errMsg": "", "suggestion": ""}
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "warning.choice.innerip")
            contextUtil.handleFailure(context, resultDict)
            return

    contextUtil.handleSuccess(context)
    logger.logPass()
    return


def getItems(context, param):
    logger = common.getLogger(context.get("logger"), __file__)

    resultList = []
    needConfigBaseIP = True

    configBaseIpAddr = contextUtil.getItem(context, "configBaseIpAddr")
    backupConfigBaseIpAddr = contextUtil.getItem(context, "backupConfigBaseIpAddr")
    if backupConfigBaseIpAddr is None:
        backupConfigBaseIpAddr = configBaseIpAddr
        contextUtil.setItem(context, "backupConfigBaseIpAddr", backupConfigBaseIpAddr)

    if common.isScaleOutExpansioned(backupConfigBaseIpAddr):
        needConfigBaseIP = False

    chooseBaseIPItems = {
        "id": "chooseBaseIP",
        "type": "dropDown",
        "label": "baseIP.baseAddr",
        "initScript": "doradoExpansion/configBaseIP.py",
        "param": "0",
        "length": 120,
    }

    originalBaseIPItems = {
        "id": "originalBaseIP",
        "type": "text",
        "label": "baseIP.baseAddr",
        "default": "#StaticText#%s" % backupConfigBaseIpAddr,
    }

    subnetMaskItems = {
        "id": "baseSubnetMask",
        "type": "label",
        "default": config.SUBNET_MASK,
        "label": "baseIP.subnetMask",
    }

    sep = {"id": "sep", "type": "9seperator"}

    if needConfigBaseIP:
        resultList.append(chooseBaseIPItems)
    else:
        resultList.append(originalBaseIPItems)
    resultList.append(subnetMaskItems)
    resultList.append(sep)

    context["retData"] = common.dictList2JsonArray(resultList)
    contextUtil.handleSuccess(context)
    logger.logPass()
    return


def initDropData(context, param):
    BaseIPDict = {"rule": ",".join(config.CHOOSE_INNER_IP), "default": config.DEFAULT_INNER_IP}
    context["retData"] = str(BaseIPDict)
    contextUtil.handleSuccess(context)
    return
