# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil
import time

def execute(context):
    '''
    @summary: 配置交换机
    '''
    
    
    resultDict = {"flag":True, "errMsg":"", "suggestion":""}
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    try:
        tlv = contextUtil.getTlv(context)
        portInfo = contextUtil.getItem(context, "MODIFY_MGMT_IP_INFO" )
        ipVer = contextUtil.getItem(context, "MODIFY_MGMT_IPVer")
        board = contextUtil.getItem(context, "MODIFY_MGMT_BOARD" )
        try:
            curDataDict = common.jsonStr2Dict(context.get("curData"))
        #界面输入非法字符时，处理json数据会失败
        except:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "switch.illegal.input")
            contextUtil.handleFailure(context, resultDict)
            return
        
        #校验界面输入项
        inputManIPList = []
        i = 0
        manIp = curDataDict['manIp%s' % i]
        if len(manIp.strip()) == 0:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "manage.ipaddress.empty.1")
            contextUtil.handleFailure(context, resultDict)
            return
        
        if not common.isIllegalManIpAddr(manIp, ipVer):
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "manage.ipaddress.error.1")
            contextUtil.handleFailure(context, resultDict)
            return
        
        #检查两次输入的管理IP是否冲突
        if not common.isConfigSameManIpAddr(manIp, inputManIPList):
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "manage.ipaddress.conflict")
            contextUtil.handleFailure(context, resultDict)
            return
        
        mask = curDataDict['mask%s' % i]
        if not common.isIllegalMask(mask, ipVer):
            resultDict["flag"] = False
            if ipVer == common.IPV4:
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "manage.mask.error.1")
            elif ipVer == common.IPV6:
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "ctrl.ip.prefix.invalid.1")
            contextUtil.handleFailure(context, resultDict)
            return
        
        gateway = curDataDict['gateway%s' % i]
        if (gateway is not None and gateway != "") and not common.isIllegalGateway(gateway, ipVer):
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "manage.gateway.error.1")
            contextUtil.handleFailure(context, resultDict)
            return
        manIPinfoDict = {"manIp":manIp, "mask":mask, "gateway":gateway}
            
        #配置修改后的管理IP
        logger.logInfo("Begin config IP...")
        (result, errMsg) = adTlvUtil.modifyManIP(lang,logger,tlv,board,manIPinfoDict,ipVer,portInfo["portLocation"])
        
        if not result:
            resultDict["errMsg"] = errMsg
            resultDict["flag"] = False
            contextUtil.handleFailure(context, resultDict)
            return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        resultDict["flag"] = False
        resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "config.manip.exception")
        contextUtil.handleFailure(context, resultDict)
        return
