# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config

def getItems(context):
    '''
    @summary: 获取确认组网的项，需要配置交换机时，弹出交换机配置窗口
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        productVersion = contextUtil.getItem(context, "productVersion")
        
        makesureItems = []
        if productVersion in config.SPECIAL_Dorado_VER:
            makesureItems.append(contextUtil.getResource(context, "confirmNetworkOrg.special.powerOnCtrls"))
        else:
            makesureItems.append(contextUtil.getResource(context, "confirmNetworkOrg.powerOnCtrls"))
        
        makesureItems.append(contextUtil.getResource(context, "confirmNetworkOrg.newCtrsNum"))
        
        jsonArray = []
        for item in makesureItems:
            jsonArray.append('{"title":"%s"}' % item)
        context["retData"] = "[%s]" % ",".join(jsonArray)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
       
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return

