# -*- coding: UTF-8 -*-
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config


def getItems(context):
    """获取更换线缆提示项，需要配置交换机时，显示配置交换机提示项

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        productVersion = contextUtil.getItem(context, "productVersion")
        productModel = contextUtil.getItem(context, "productModel")
        hasInnerMetro = contextUtil.getItem(context, "hasInnerMetroLicense")
        newConfigClustType = contextUtil.getItem(context, "newConfigClustType")
        makesureItems = []
        # 提示组网图
        networkingItem = contextUtil.getResource(context,
                                                 "replacingPlane.makesure")
        # 如果是V6高端设备，且导入了内双活license，则在组网提示后面追加一段提示
        if baseUtil.isDoradoV6HighEnd(productModel) and hasInnerMetro:
            networkingItem += contextUtil.getResource(
                context, "replacingPlane.hyperMetroInner")

        makesureItems.append(networkingItem)

        if productVersion in config.SPECIAL_Dorado_VER:
            makesureItems.append(contextUtil.getResource(context, "confirmNetworkOrg.special.powerOnCtrls"))
        else:
            makesureItems.append(contextUtil.getResource(context, "confirmNetworkOrg.powerOnCtrls"))

        makesureItems.append(contextUtil.getResource(context, "confirmNetworkOrg.newCtrsNum"))

        if newConfigClustType == "switch":
            makesureItems.append(contextUtil.getResource(
                context, "replacingPlane.configIPandSSH"))
            makesureItems.append(contextUtil.getResource(
                context, "replacingPlane.manuallyConfigSwitchlink"))

        jsonArray = []
        for item in makesureItems:
            jsonArray.append('{"title":"%s"}' % item)
        context["retData"] = "[%s]" % ",".join(jsonArray)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def confirm(context):
    newConfigClustType = contextUtil.getItem(context, "newConfigClustType")
    configClustType = contextUtil.getItem(context, "configClustType")

    # 弹出生成配置交换机的窗口
    if common.needConfigSwitch(newConfigClustType, configClustType):
        common.popupConfigSwtichDialog(context)
    contextUtil.handleSuccess(context)
    return

