# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config

#进度总剩余时间
LIMIT_TIME = 30
#进度刷新间隔
INTERVAL = 2

def execute(context):
    '''
    @summary: 修改配置信息
    '''
    node = None
    try:
        #进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        #进度开始
        common.inProcess(context)
        
        logger = common.getLogger(context.get("logger"), __file__)
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        context["remindInfo"] = common.getDangerNoticeRemindInfo(lang)
        
        originCtrlNum = contextUtil.getItem(context, "ctrlNum")
        newConfigCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
        oldBoardsList = contextUtil.getItem(context, "oldBoardsList")
        newBoardsList = contextUtil.getItem(context, "newBoardsList")
        innterIpNet0Addr = contextUtil.getItem(context, "innterIpNet0Addr")
        innterIpNet1Addr = contextUtil.getItem(context, "innterIpNet1Addr")
        innterIPInfo = {}
        innterIPInfo["innterIpNet0Addr"] = str(innterIpNet0Addr)
        innterIPInfo["innterIpNet1Addr"] = str(innterIpNet1Addr)
        bayIdInfo = contextUtil.getItem(context, "bayIdInfo")
        ctrlHeight = contextUtil.getItem(context, "ctrlHeight")

        contextUtil.setItem(context, contextUtil.EXP_FLOW_STATUS_KEY, contextUtil.EXP_FLOW_STATUS_CHANGE_DATA)
        newBayIDlist = []
        newBoardsDict = {}
        for board in newBoardsList:
            node = board
            newBayID = common.getNodeBayIdByEam(bayIdInfo, board)
            if newBayID == None:
                logger.logInfo('Get bay id failed')
                raise Exception
            newBayIDlist.append(newBayID)
            newBoardsDict[(board["enclosureSN"],board["controllerID"])] = newBayID
            
        newBayIDlist.sort()
        newBayIDsTuple = tuple(newBayIDlist)
        logger.logInfo("newbayids:"+str(newBayIDsTuple))
        
        #按照bayid从小到大排序，便于后面修改配置或重启
        newBoardsList = common.sortBoardsSnByBayId(newBoardsDict, newBoardsList)
        logger.logInfo("[modifyConfig]refresh newBoardsList:%s"+str(newBoardsList))
        contextUtil.setItem(context, "newBoardsList", newBoardsList)
        
        #用查上来的newBayIds元组与配置文件中配好的进行比对
        devObj = contextUtil.getDevObj(context)
        productModel = devObj.get("type")
        if common.isDorado18000(productModel):
            expansionBayIdSpecDict = config.DORADO18000_NEW_BAYID_SPEC_DICT
        else:
            expansionBayIdSpecDict = config.DORADO_NEW_BAYID_SPEC_DICT

        if newBayIDsTuple != expansionBayIdSpecDict["%dU%dC" % (ctrlHeight,originCtrlNum)]["%dC" % newConfigCtrlNum]["newBayIDsTuple"]:
            logger.logNoPass("The newBayIds provided by the system are illegal.")
            resultDict = {"flag":False, "errMsg":"", "suggestion":""}
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "new.bayid.illegal")
            contextUtil.handleFailure(context, resultDict)
            return           
        
            
        for board in newBoardsList:
            node = board
            newBayID = common.getNodeBayIdByEam(bayIdInfo, board)
            if newBayID == None:
                logger.logInfo('Get bay id failed')
                raise Exception
            ctrlNum = newConfigCtrlNum
            adTlvUtil.modifyBayIDCtrlNum(tlv, board, newBayID, ctrlNum)
            logger.logInfo("write bay id and ctrlNum success[newCtrl]:%s" % board)
        
        for board in newBoardsList:
            node = board
            adTlvUtil.modifyInnterIP(tlv, board, innterIPInfo)
            logger.logInfo("write xnetInfo success[newCtrl]:%s" % board)
        
        for board in oldBoardsList:
            node = board
            adTlvUtil.modifyCtrlNum(tlv, board, newConfigCtrlNum)
            logger.logInfo("write ctrlNum success[oldCtrl]:%s" % board)
            
        for board in oldBoardsList:
            node = board
            adTlvUtil.modifyInnterIP(tlv, board, innterIPInfo)
            logger.logInfo("write xnetInfo success[oldCtrl]:%s" % board)
            
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        if node is None:
            contextUtil.handleException(context, exception)
        else:
            lang = contextUtil.getLang(context)
            resultDict = {"flag":False, "errMsg":"", "suggestion":""}
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "modify.config.failure", node["enclosureSN"])
            contextUtil.handleException(context, exception, resultDict)
        logger.logException(exception)
        return
    finally:
        context["remindInfo"] = ""
        #进度条刷为完成状态
        common.finishProcess(context)