# -*- coding: UTF-8 -*-
import threading
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.expansion import common
from cbb.frame.base import baseUtil

CHECK_STATE_CHECKING = "checking"


def execute(context):
    '''

    @summary: 重启待扩容控制器
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        context["remindInfo"] = common.getDangerNoticeRemindInfo(lang)
        
        ctrlNum = contextUtil.getItem(context, "ctrlNum")
        newBoardsList = contextUtil.getItem(context, "newBoardsList")
        version = contextUtil.getItem(context, "productVersion")
        
        #所有的新引擎所在框SN集合
        newEnclosuresList = common.getNewEnclosuresList(newBoardsList)
        #已加入集群的新引擎所在框数量
        expansionedEnclosuresNum = 0
        #需要加入集群的新引擎所在框总数
        totalEnclosuresNum = len(newEnclosuresList)
        
        maxPowerOnTime = common.getPoweronCtrlTime(version)
        #单个框超时时间
        powerOnTime = common.getTypicalPowerOnTime(contextUtil.getItem(context,"ctrlHeight"), maxPowerOnTime)
        
        #剩余时间总数
        totalReaminTime = totalEnclosuresNum * powerOnTime
        contextUtil.setItem(context, "totalReaminTime", totalReaminTime)

        # 设置剩余时间
        context["curRemainTime"] = totalReaminTime
        # 设置进度
        common.setExpansionProgress(context, True)
        #当前集群需要的控制器个数
        currentCtrlNum = ctrlNum
        #集群开工正常标识
        isStartWorkOK = True

        context["checkState"] = CHECK_STATE_CHECKING
        context["minRemainTime"] = (totalEnclosuresNum - expansionedEnclosuresNum - 1) * powerOnTime
        t = threading.Thread(target=updateProcess, args=(context,))
        t.start()

        contextUtil.setItem(context, contextUtil.EXP_FLOW_STATUS_KEY, contextUtil.EXP_FLOW_STATUS_REBOOT_NEW_CONTROLLER)
        newConfigCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
        adTlvUtil.restartAD(context, tlv, logger, ctrlNum)
        #缓存已重启的新扩控，在重新执行本步骤时跳过
        restartedEnclosuresList = contextUtil.getItem(context, "restartedEnclosuresList")
        if restartedEnclosuresList == None:
            restartedEnclosuresList = []
            contextUtil.setItem(context, "restartedEnclosuresList", restartedEnclosuresList)

        errMsg = ""
        suggestion = ""
        for newEnclosure in newEnclosuresList:
            logger.logInfo("threading is start: " + newEnclosure)
            #该框下节点个数
            nodesNum = common.getEnclosureNodes(newEnclosure, newBoardsList)
            if newEnclosure in restartedEnclosuresList:
                logger.logInfo("Enclosure has being restart before skip : " + newEnclosure)
            else:
                #逐框重启
                for board in newBoardsList:
                    if board["enclosureSN"] != newEnclosure:
                        continue
                    try:
                        logger.logInfo("[rebootCtrl]start reboot controller. SN:%s, nodeNum:%s." %(newEnclosure, str(nodesNum)))
                        context["remindInfo"] = common.getRemindInfo(lang, "expansion.being.rebooted.notice", newEnclosure)
                        stopFeedDogRecord = adTlvUtil.stopFeedDog(tlv, board, nodesNum)
                        logger.logInfo("stopFeedDogRecord:%s" % stopFeedDogRecord)
                    except Exception as exception:
                        logger.logNoPass("stop feed dog failure(node info:%s)" % str(board))
                        logger.logException(exception)

            #验证新引擎是否加入原集群
            currentCtrlNum += nodesNum
            cli = contextUtil.getCli(context)
            ret = common.checkClusterCtrlsNumWithDetail(context, cli, lang, currentCtrlNum, newEnclosure, traceType= "354", timeOut = powerOnTime, maxTimeOut = maxPowerOnTime, rollbackInfo={"rollback":True})
            if ret["flag"] == False:
                logger.logNoPass("expansion new engine failure(enclosureSN:%s)" % newEnclosure)
                isStartWorkOK = False
                errMsg = ret["errMsg"]
                suggestion = ret["suggestion"]
                break

            if newEnclosure not in restartedEnclosuresList:
                restartedEnclosuresList.append(newEnclosure)
            #如果控制数量与期望一致，表明所有新扩控都已加入集群，不需再重启剩余新扩控
            if ret["ret"]!="" and  int(ret["ret"])==newConfigCtrlNum:
                isStartWorkOK = True
                logger.logInfo("checkClusterCtrlsNumWithDetail ALL OK, ctrlNum=%s" % newConfigCtrlNum)
                break

            expansionedEnclosuresNum += 1
            # 设置剩余时间
            context["curRemainTime"] = (totalEnclosuresNum - expansionedEnclosuresNum) * powerOnTime
            if context["curRemainTime"] != 0:
                context["minRemainTime"] = (totalEnclosuresNum - expansionedEnclosuresNum - 1) * powerOnTime
            else:
                context["curRemainTime"] = common.NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_UPDATE
            context["remindInfo"] = common.getRemindInfo(lang, "expansion.rebooted.notice", newEnclosure)
            # 设置进度
            common.setExpansionProgress(context, True)

        #停用部署功能
        try:
            adTlvUtil.stopAD(tlv)
        except Exception as exception:
            logger.logNoPass("stop AD failure")
        logger.logInfo("AD stoped")
        
        if not isStartWorkOK:
            resultDict["flag"] = False
            if errMsg == "":
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "expansion.reboot.failure", newEnclosure)
            else:
                resultDict["errMsg"], resultDict["suggestion"] = errMsg, suggestion
            contextUtil.handleFailure(context, resultDict)
            return

        contextUtil.setItem(context, "restartedEnclosuresList", [])
        contextUtil.setItem(context, contextUtil.EXP_FLOW_STATUS_KEY, contextUtil.EXP_FLOW_STATUS_JOIN_SYS_SUCCESS)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        try:
            context["checkState"] = "finished"
            t.join()
        except Exception as exception:
            logger.logException(exception)
        finally:
            context["curRemainTime"] = 0
            context["remindInfo"] = ""
            common.setExpansionProgress(context, True)

def updateProcess(context):
    while context["checkState"] == CHECK_STATE_CHECKING:
        # 更新进度条
        baseUtil.safeSleep(common.NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_UPDATE)
        context["curRemainTime"] -= common.NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_UPDATE
        if context["curRemainTime"] < context["minRemainTime"]:
            context["curRemainTime"] = context["minRemainTime"]
        if context["curRemainTime"] <= 0:
            context["curRemainTime"] = common.NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_UPDATE
        common.setExpansionProgress(context, True)
