# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config

def execute(context):
    '''
    @summary: Set the innerNetIP and check whether the ip is  colliding with the manangement ports
    '''
    isModify = True
    while(isModify):
        isModify = isModifyIpAgain(context)
        if isModify:
            popModfiyPanel(context)
            if contextUtil.getItem(context,"modifyBaseIpAddr") is None:
                return
        else:
            return
    return

def isModifyIpAgain(context):
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        context["remindInfo"] = common.getDangerNoticeRemindInfo(lang)
        tlv = contextUtil.getTlv(context)
        oldBoardsList = contextUtil.getItem(context, "oldBoardsList")
        newBoardsList = contextUtil.getItem(context, "newBoardsList")
        bayConfigCtrlNum = contextUtil.getItem(context, "configCtrlNum")
        configBaseIpAddr = contextUtil.getItem(context, "backupConfigBaseIpAddr")
        selectedBaseIpAddr = contextUtil.getItem(context, "selectedBaseIpAddr")
        encHeight = contextUtil.getItem(context, "ctrlHeight")
        newCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
        logger.logInfo("the oriInner IP is %s" % configBaseIpAddr)
        logger.logInfo("selected inner IP is %s" % selectedBaseIpAddr)

        if encHeight == 6 and (bayConfigCtrlNum, newCtrlNum) in config.NONEED_BASEIP_NEWWORK:
            logger.logInfo("Do not need check ip collide.")
            contextUtil.handleSuccess(context)
            logger.logPass()
            return False

        ipadd = selectedBaseIpAddr
        if common.isScaleOutExpansioned(configBaseIpAddr):
            ipadd = configBaseIpAddr

        innterNet0IpAddr = None
        innterNet1IpAddr = None
        if ipadd in config.INNER_IP_GROUP1:
            innterNet0IpAddr = config.INNER_IP_GROUP1[0]
            innterNet1IpAddr = config.INNER_IP_GROUP1[1]
        elif ipadd in config.INNER_IP_GROUP2:
            innterNet0IpAddr = config.INNER_IP_GROUP2[0]
            innterNet1IpAddr = config.INNER_IP_GROUP2[1]

        boardsList = oldBoardsList + newBoardsList

        innterIPInfo = {}
        innterIPInfo["innterIpNet0Addr"] = str(innterNet0IpAddr)
        innterIPInfo["innterIpNet1Addr"] = str(innterNet1IpAddr)
        innterIPInfo["subnetMask"] = str(config.SUBNET_MASK)

        logger.logInfo("the inner IP is %s and %s" % (innterNet0IpAddr, innterNet1IpAddr))
        for board in boardsList:
            adTlvUtil.checkInnterIP(logger, tlv, board, innterIPInfo)
            logger.logInfo("write ctrlNum success[oldCtrl]:%s" % board)

        contextUtil.setItem(context, "innterIpNet0Addr", innterNet0IpAddr)
        contextUtil.setItem(context, "innterIpNet1Addr", innterNet1IpAddr)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return False

    except Exception as exception:
        expArgs = exception.args
        if expArgs is not None and len(expArgs) == 2:
            errCode = str(expArgs[0]).strip()
            if not common.isScaleOutExpansioned(configBaseIpAddr):
                if common.IP_CONFLICT_ERRCODE_UNEXPANSIONED_DEFINE.has_key(errCode):
                    errMsg, suggestion = common.getMsg(lang, common.IP_CONFLICT_ERRCODE_UNEXPANSIONED_DEFINE[errCode],
                                                       board["enclosureSN"])
                    resultDict = {"flag": False, "errMsg": errMsg, "suggestion": suggestion}
                    contextUtil.handleFailure(context, resultDict)
                    return True
            else:
                if common.IP_CONFLICT_ERRCODE_EXPANSIONED_DEFINE.has_key(errCode):
                    errMsg, suggestion = common.getMsg(lang, common.IP_CONFLICT_ERRCODE_EXPANSIONED_DEFINE[errCode],
                                                       board["enclosureSN"])
                    resultDict = {"flag": False, "errMsg": errMsg, "suggestion": suggestion}
                    contextUtil.handleFailure(context, resultDict)
                    return False

        logger.logException(exception)
        errMsg, suggestion = common.getMsg(lang, "confilict.common.info")
        resultDict = {"flag": False, "errMsg": errMsg, "suggestion": suggestion}
        contextUtil.handleFailure(context, resultDict)
        return False
    finally:
        context["remindInfo"] = ""


def popModfiyPanel(context):
    '''
    @summary: if ip is collided, open a panel to modify.
    '''
    defaultBaseConfigIp = common.getDefaultBaseConfigIp(context)
    if contextUtil.getItem(context, "succ"):
        return True

    contextUtil.setItem(context, "modifyBaseIpAddr", None)
    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo("popupSelectExpansionDialog start")

    lang = contextUtil.getLang(context)

    title = common.getRes(lang, "modifyExpansion_baseAddr")
    desc = context["errMsg"]

    logger.logInfo("title start:%s, %s" %(title, desc))
    width = '450'

    # 窗口设置
    dialogInfo = {'title': title, 'desc': desc, 'width': width, 'height': '300'}
    jDiaglogInfo = common.getJsonStr(dialogInfo)

    # 脚本设置
    checkScript = "common/saveExpansionMode.py"
    checkMethod = "executeIpConfig"

    # 窗体内容设置
    inputComponent = []

    # 获取基地址
    chooseBaseIPItems = {
        "id": "modifyBaseIP",
        "name": common.getRes(lang, "selectExpansion_baseAddr"),
        "type": "dropdown",
        "rule": defaultBaseConfigIp["rule"],
        "default": contextUtil.getItem(context,"selectedBaseIpAddr"),
        "toolTip": common.getRes(lang, "selectExpansion_baseAddr_tip"),
    }
    inputComponent.append(chooseBaseIPItems)

    jInputComponent = common.getJsonStr(inputComponent)

    dialogUtil = context.get('dialogUtil')
    dialogUtil.showInputDialog(jDiaglogInfo, checkScript, checkMethod, jInputComponent)


