# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil

def execute(context):
    '''
    @summary: 检查待扩容控制器产品型号
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        newBoardsList = contextUtil.getItem(context, "newExpansionBoardsList")
        oldBoardsList = contextUtil.getItem(context, "oldBoardsList")
        logger.logNoPass('old bord send ctrl begin')
        ret1 = adTlvUtil.getProductModelTestAd(tlv, oldBoardsList[0], sendCtrlId=True)
        logger.logNoPass('old bord send no ctrl begin')
        ret2 = adTlvUtil.getProductModelTestAd(tlv, oldBoardsList[0], sendCtrlId=False)
        logger.logNoPass('new bord send ctrl begin')
        ret3 = adTlvUtil.getProductModelTestAd(tlv, newBoardsList[0], sendCtrlId=True)
        logger.logNoPass('new bord send no ctrl begin')
        ret4 = adTlvUtil.getProductModelTestAd(tlv, newBoardsList[0], sendCtrlId=False)

        logger.logNoPass('ret1:%s' % ret1)
        logger.logNoPass('ret2:%s' % ret2)
        logger.logNoPass('ret3:%s' % ret3)
        logger.logNoPass('ret4:%s' % ret4)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
