# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.expansion import common

def execute(context):
    '''
    @summary: 修改BMC
    '''
    node = None
    try:
        logger = common.getLogger(context.get("logger"), __file__)

        contextUtil.setItem(context, contextUtil.EXP_FLOW_STATUS_KEY, contextUtil.EXP_FLOW_STATUS_CHANGE_DATA)
        tlv = contextUtil.getTlv(context)
        originalBoardsList = contextUtil.getItem(context, "originalBoardsList")
        for board in originalBoardsList:
            node = board
            adTlvUtil.syncBMC(tlv, board)

        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        if node is None:
            contextUtil.handleException(context, exception)
        else:
            lang = contextUtil.getLang(context)
            resultDict = {"flag":False, "errMsg":"", "suggestion":""}
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "sync.config.failure", node["enclosureSN"])
            contextUtil.handleException(context, exception, resultDict)
        logger.logException(exception)
        return
