# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def execute(context):
    '''
    @summary: 修改已扩容引擎管理IP
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)
        
        ipVer = contextUtil.getItem(context, "ipVer")
        eng0BayIds = ["0"]
        newBayIds = contextUtil.getItem(context, "newBayIds")
        eng0ManIpList = contextUtil.getItem(context, "eng0ManIpList")
        eng1ManIpList = contextUtil.getItem(context, "eng1ManIpList")
        
        manPortIdListRet = common.getManPortIdList(cli, lang)
        if manPortIdListRet["flag"] != True:
            logger.logNoPass("Getting management ports failure")
            contextUtil.handleFailure(context, manPortIdListRet)
            return
        
        #配置单扩双的IP start
        manPortIdDict = {}
        for manPortId in manPortIdListRet["ret"]:
            if "A" in manPortId:
                continue
            manPortArr = manPortId.split(".")
            if len(manPortArr) != 3:
                continue
            eng = manPortArr[0][-1]
            slot = manPortArr[1][-1]
            if eng not in eng0BayIds:
                continue
            
            if not manPortIdDict.has_key(eng):
                slotsDict = {}
                slotsDict[slot] = [manPortId]
            else:
                slotsDict = manPortIdDict.get(eng)
                if slotsDict.has_key(slot):
                    newManPortIdList = slotsDict.get(slot)
                    newManPortIdList.append(manPortId)
                    slotsDict[slot] = newManPortIdList
                else:
                    slotsDict[slot] = [manPortId]
            manPortIdDict[eng] = slotsDict.copy()
        logger.logInfo("eng0ManPortIdDict:%s" % manPortIdDict)
        
        eng0ManIpDictList = []
        for eng in manPortIdDict.keys():
            slotsDict = manPortIdDict.get(eng)
            slots = slotsDict.keys()
            slots.sort()
            for i in range(0, len(slots)):
                manIp = common.getManIP(eng0ManIpList, eng, i)
                mask = common.getMask(eng0ManIpList, eng, i)
                gateway = common.getGateway(eng0ManIpList, eng, i)
                if len(manIp) == 0:
                    continue
                
                manIpDict = {}
                manIpDict["eth_port_id"] = slotsDict.get(slots[i])[0]
                manIpDict["address"] = manIp
                manIpDict["mask"] = mask
                manIpDict["gateway"] = gateway
                eng0ManIpDictList.append(manIpDict.copy())

        logger.logInfo("eng0ManIpDictList:%s" % eng0ManIpDictList)
        #配置单控双的IP end
        
        #配置双控四的IP start
        for manPortId in manPortIdListRet["ret"]:
            manPortArr = manPortId.split(".")
            if len(manPortArr) != 3:
                continue
            eng = manPortArr[0][-1]
            slot = manPortArr[1][-1]
            if eng not in newBayIds:
                continue
            
            if not manPortIdDict.has_key(eng):
                slotsDict = {}
                slotsDict[slot] = [manPortId]
            else:
                slotsDict = manPortIdDict.get(eng)
                if slotsDict.has_key(slot):
                    newManPortIdList = slotsDict.get(slot)
                    newManPortIdList.append(manPortId)
                    slotsDict[slot] = newManPortIdList
                else:
                    slotsDict[slot] = [manPortId]
            manPortIdDict[eng] = slotsDict.copy()
        logger.logInfo("eng1ManPortIdDict:%s" % manPortIdDict)
        
        eng1ManIpDictList = []
        for eng in manPortIdDict.keys():
            slotsDict = manPortIdDict.get(eng)
            slots = slotsDict.keys()
            slots.sort()
            for i in range(0, len(slots)):
                manIp = common.getManIP(eng1ManIpList, eng, i)
                mask = common.getMask(eng1ManIpList, eng, i)
                gateway = common.getGateway(eng1ManIpList, eng, i)
                if len(manIp) == 0:
                    continue
                
                manIpDict = {}
                manIpDict["eth_port_id"] = slotsDict.get(slots[i])[0]
                manIpDict["address"] = manIp
                manIpDict["mask"] = mask
                manIpDict["gateway"] = gateway
                eng1ManIpDictList.append(manIpDict.copy())

        logger.logInfo("eng1ManIpDictList:%s" % eng1ManIpDictList)
        #配置双控四的IP end
        
        #修改待扩容控制器管理网口IP
        manIpDictList = eng0ManIpDictList + eng1ManIpDictList
        modifyManIPRetDict = common.modifyManIP(cli, lang, manIpDictList, ipVer)
        logger.logInfo("config management IP results:%s" % modifyManIPRetDict["ret"])
        if not modifyManIPRetDict["flag"]:
            contextUtil.handleFailure(context, modifyManIPRetDict)
            return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
