# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvUtil
from cbb.business.operate.expansion import common

def execute(context):
    '''
    @summary: 执行扩容控制器
    '''
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        contextUtil.setItem(context, contextUtil.EXP_FLOW_STATUS_KEY, contextUtil.EXP_FLOW_STATUS_CHANGE_DATA)
        tlv = contextUtil.getTlv(context)
        try:
            tlvUtil.expandCtrlCapacity(tlv, isIpScaleOut = True)
        except Exception as exception:
            lang = contextUtil.getLang(context)
            resultDict = {"flag":False, "errMsg":"", "suggestion":""}
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "notify.expansion.failure.v3")
            contextUtil.handleException(context, exception, resultDict)
            logger.logException(exception)
            return
        logger.logInfo("excute expansion")
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
    
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
