# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.expansion import common

#进度总剩余时间
LIMIT_TIME = 30
#进度刷新间隔
INTERVAL = 2

def execute(context):
    '''
    @summary: 启动AD并修改配置信息
    '''
    node = None
    try:
        #进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        #进度开始
        common.inProcess(context)
        
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        ctrlNum = contextUtil.getItem(context, "ctrlNum")
        contextUtil.setItem(context, contextUtil.EXP_FLOW_STATUS_KEY, contextUtil.EXP_FLOW_STATUS_CHANGE_DATA)

        #启动AD
        startedADNum = adTlvUtil.startAD(tlv)
        if startedADNum < ctrlNum:
            contextUtil.setItem(context, "isADStarted", False)
            logger.logNoPass("start AD failure(startedADNum:%s, ctrlNum:%s)" % (startedADNum, ctrlNum))
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "start.ad.failure")
            contextUtil.handleFailure(context, resultDict)
            return 
        contextUtil.setItem(context, "isADStarted", True)
        logger.logInfo("AD started")
        
        #下发是否扩容配置
        notifyADRet = adTlvUtil.notifyAD(tlv)
        if notifyADRet == 0:
            logger.logNoPass("notify AD failure")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "notify.ad.failure")
            contextUtil.handleFailure(context, resultDict)
            return 
        logger.logInfo("AD notified")
        
        #查询框和节点
        boardsList = adTlvUtil.getBoards(tlv)
        originEnclosureSNs = contextUtil.getItem(context, "originEnclosureSNs")
        originalBoardsList = [board for board in boardsList if board["enclosureSN"] in originEnclosureSNs]
        
        logger.logInfo("originalBoardsList:%s" % originalBoardsList)
        
        contextUtil.setItem(context, "originalBoardsList", originalBoardsList)
        
        #修改配置信息
        newConfigCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
        for board in originalBoardsList:
            node = board
            adTlvUtil.modifyCtrlNum(tlv, board, newConfigCtrlNum)
            logger.logInfo("write ctrlNum success[oldCtrl]:%s" % board)
            
        for board in originalBoardsList:
            if board["controllerID"] in [4, 5]:
                bayConfigInfo = adTlvUtil.readXnetInfo(tlv,board)
                adTlvUtil.modifyXnetInfoToFixedValue(tlv, board, bayConfigInfo)
            
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        if node is None:
            contextUtil.handleException(context, exception)
        else:
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "modify.config.failure", node["enclosureSN"])
            contextUtil.handleException(context, exception, resultDict)
        logger.logException(exception)
        return
    finally:
        #进度条刷为完成状态
        common.finishProcess(context)
