# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def getItems(context, param):
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        ipVer = contextUtil.getItem(context, "ipVer")
        resultList = []
        
        newBayId = 0
        
        #当前引擎新控制器IP设置
        idIp1 = "eng%s.ip" % newBayId
        idMask1 = "eng%s.mask" % newBayId
        idGateway1 = "eng%s.gateway" % newBayId
        
        labelIp1 = "manIPSingle.eng.%s.ip" % ipVer
        labelMask1 = "manIPSingle.eng.%s.mask" % ipVer
        labelGateway1 = "manIPSingle.eng.%s.gateway" % ipVer
            
        ip1 = {"id":idIp1,"type":"text","label":labelIp1,"default":""}
        mask1 = {"id":idMask1,"type":"text","label":labelMask1,"default":""}
        gateway1 = {"id":idGateway1,"type":"text","label":labelGateway1,"default":""}
        resultList.extend([ip1, mask1, gateway1])
        
        context["retData"] = common.dictList2JsonArray(resultList)
        contextUtil.handleSuccess(context)
        
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    return
