# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def getItems(context, param):
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        ipVer = contextUtil.getItem(context, "ipVer")
        resultList = []
        newBayIds =  [int(item) for item in set(contextUtil.getItem(context, "newBayIds"))]
        logger.logInfo("newBayIds:%s" % newBayIds)
        
        #只配置一个新引擎的管理IP，其他引擎管理IP不配置
        newBayId = newBayIds[0]
            
        idIp1 = "eng%s.ip1" % newBayId
        idIp2 = "eng%s.ip2" % newBayId
        idMask1 = "eng%s.mask1" % newBayId
        idMask2 = "eng%s.mask2" % newBayId
        idGateway1 = "eng%s.gateway1" % newBayId
        idGateway2 = "eng%s.gateway2" % newBayId
        
        labelIp1 = "manIP.eng.%s.ip1" % ipVer
        labelIp2 = "manIP.eng.%s.ip2" % ipVer
        labelMask1 = "manIP.eng.%s.mask1" % ipVer
        labelMask2 = "manIP.eng.%s.mask2" % ipVer
        labelGateway1 = "manIP.eng.%s.gateway1" % ipVer
        labelGateway2 = "manIP.eng.%s.gateway2" % ipVer
            
        ip1 = {"id":idIp1,"type":"text","label":labelIp1,"default":""}
        mask1 = {"id":idMask1,"type":"text","label":labelMask1,"default":""}
        gateway1 = {"id":idGateway1,"type":"text","label":labelGateway1,"default":""}
        ip2 = {"id":idIp2,"type":"text","label":labelIp2,"default":""}
        mask2 = {"id":idMask2,"type":"text","label":labelMask2,"default":""}
        gateway2 = {"id":idGateway2,"type":"text","label":labelGateway2,"default":""}
        resultList.extend([ip1, mask1, gateway1, ip2, mask2, gateway2])

        context["retData"] = common.dictList2JsonArray(resultList)
        contextUtil.handleSuccess(context)
        
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    return
