# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def saveData(context):
    '''
    @summary: 保存已扩容引擎管理IP
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        
        newBayIds = [int(item) for item in set(contextUtil.getItem(context, "newBayIds"))]
        baseIpAddr = contextUtil.getItem(context, "baseIpAddr")
        ipVer = contextUtil.getItem(context, "ipVer")
        manIpList = []
        
        #单控扩双控IP设置 start
        newBayId = 0
        manIpList.append({"bayid":newBayId, "slot":0, 
          "manIp":context["input_configManIPHybrid_eng%s.ip" % newBayId],
          "mask":context["input_configManIPHybrid_eng%s.mask" % newBayId],
          "gateway":context["input_configManIPHybrid_eng%s.gateway" % newBayId]})
        #单控扩双控IP设置 end
        
        #双控扩四控IP设置 start
        newBayId = newBayIds[0]
        manIpList.append({"bayid":newBayId, "slot":0, 
          "manIp":context["input_configManIPHybrid_eng%s.ip1" % newBayId],
          "mask":context["input_configManIPHybrid_eng%s.mask1" % newBayId],
          "gateway":context["input_configManIPHybrid_eng%s.gateway1" % newBayId]})
        manIpList.append({"bayid":newBayId, "slot":1, 
          "manIp":context["input_configManIPHybrid_eng%s.ip2" % newBayId],
          "mask":context["input_configManIPHybrid_eng%s.mask2" % newBayId],
          "gateway":context["input_configManIPHybrid_eng%s.gateway2" % newBayId]})
        #双控扩四控IP设置 end
        
        eng0ManIpList = [manIpList[0]]
        logger.logInfo("eng0ManIpList:%s" % eng0ManIpList)
        eng1ManIpList = manIpList[1:]
        logger.logInfo("eng1ManIpList:%s" % eng1ManIpList)
        
        allManIps = []
        for manIpDict in manIpList:
            ctrlIpAddr = manIpDict["manIp"]
            mask = manIpDict["mask"]
            gateway = manIpDict["gateway"]
            allManIps.append(ctrlIpAddr)
            
            labelBayId = manIpDict["bayid"]
            labelIdx = ""
            if int(labelBayId) != 0:
                labelIdx = manIpDict["slot"] + 1
            
            logger.logInfo("ctrlIpAddr:%s" % ctrlIpAddr)
            logger.logInfo("ipVer:%s" % ipVer)
            if not common.isIllegalManIpAddr(ctrlIpAddr, ipVer):
                errMsg, suggestion = common.getMsg(lang, "eng.ctrl.ip.addr.invalid", (labelBayId, ipVer, labelIdx))
                resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                contextUtil.handleFailure(context, resultDict)
                return

            if not common.isIllegalMask(mask, ipVer):
                if ipVer == common.IPV4:
                    errMsg, suggestion = common.getMsg(lang, "eng.ctrl.ip.mask.invalid", (labelBayId, labelIdx))
                    resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                    contextUtil.handleFailure(context, resultDict)
                    return
                else:
                    errMsg, suggestion = common.getMsg(lang, "eng.ctrl.ip.prefix.invalid", (labelBayId, labelIdx))
                    resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                    contextUtil.handleFailure(context, resultDict)
                    return

            if (gateway is not None and gateway != "") and not common.isIllegalGateway(gateway, ipVer):
                errMsg, suggestion = common.getMsg(lang, "eng.ctrl.ip.gateway.invalid", (labelBayId, labelIdx))
                resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                contextUtil.handleFailure(context, resultDict)
                return
            
            baseIpPrefix = ".".join(baseIpAddr.split(".")[0:2]) + "."
            if ctrlIpAddr.startswith(baseIpPrefix):
                errMsg, suggestion = common.getMsg(lang, "ip.address.conflict", (labelBayId, labelIdx))
                resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
                contextUtil.handleFailure(context, resultDict)
                return
        
        if len(allManIps) != len(set(allManIps)):
            errMsg, suggestion = common.getMsg(lang, "eng.ip.conflict")
            resultDict = {"flag":False, "errMsg":errMsg, "suggestion":suggestion}
            contextUtil.handleFailure(context, resultDict)
            return
        
        contextUtil.setItem(context, "eng0ManIpList", eng0ManIpList)
        contextUtil.setItem(context, "eng1ManIpList", eng1ManIpList)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
