# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common


def cancel(context):
    '''
    @summary: 扩容中，用户点击取消时按钮时处理
    '''

    logger = common.getLogger(context.get("logger"), __file__)
    try:
        # 弹出提示框，SMB开关已开启
        lang = contextUtil.getLang(context)
        cifs_status = contextUtil.getItem(context, "cifs_status")
        if cifs_status == "No":
            dialogUtil = context.get("dialogUtil")
            err_msg = common.getRes(lang, "SMB_tasks_has_open")
            next_proc = dialogUtil.showInfoDialog(err_msg)
            context["nextProc"] = next_proc
            context["remind"] = True
            context["isRefresh"] = False
            contextUtil.setItem(context, "cifs_status", None)

        # 取消扩容向导步骤后，清除上下文扩容流程管理对象。
        contextUtil.setItem(context, 'expCtrlFlow', None)
        contextUtil.setItem(context, 'lastFailStep', None)
        logger.logInfo('Canceling expansion flow, clear expansion flow object and last fail step'
                       ' in context.')

        lang = contextUtil.getLang(context)

        errMsgKey = "expansion.cancel.prompt.ipscaleout"

        dangerMsg,suggestion = common.getMsg(lang, errMsgKey)
        context["succ"] = False
        context["errMsg"] = ""
        context["dangerMsg"] = dangerMsg
        context["suggestion"] = suggestion
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
