# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil
from cbb.frame.tlv import tlvData
from cbb.frame.base import funcUtils

# 进度总剩余时间
LIMIT_TIME = 600
# 进度刷新间隔
INTERVAL = 5


@funcUtils.fakeProgress(totalSecs=LIMIT_TIME, intervalSec=INTERVAL)
def execute(context):
    '''
    @summary: 检查接口卡状态和工作模式
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    try:

        result_dict = {"flag": True, "errMsg": "", "suggestion": ""}

        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        product_model = contextUtil.getProductModel(context)
        net_working_type = contextUtil.getItem(context, "newConfigClustType",
                                               "")
        expansion_spec = contextUtil.getItem(context, "expansionSpec")
        boards_list = contextUtil.getItem(context, "boardsList")
        switch_off_boards_list = contextUtil.getItem(context,
                                                     "switchOffBoardsList")
        switch_on_boards_list = contextUtil.getItem(context,
                                                    "switchOnBoardsList")
        old_ctrl_num = contextUtil.getItem(context, "ctrlNum")
        # 扩容前预处理，禁转发，打开通道等
        adTlvUtil.preExpansion(tlv, old_ctrl_num, logger)

        # 关闭框的定位灯
        if switch_off_boards_list is not None:
            for board in switch_off_boards_list:
                set_enclosure_switch_off_ret = adTlvUtil.setEnclosureSwitchOff(
                    tlv, board)
                logger.logInfo("board %s setEnclosureSwitchOff result:%s" % (
                    board, set_enclosure_switch_off_ret))
        contextUtil.setItem(context, "switchOffBoardsList", [])

        # 打开框的定位灯
        if switch_on_boards_list is not None:
            for board in switch_on_boards_list:
                set_enclosure_switch_on_ret = adTlvUtil.setEnclosureSwitchOn(
                    tlv, board)
                logger.logInfo("board %s setEnclosureSwitchOn result:%s" % (
                    board, set_enclosure_switch_on_ret))
        contextUtil.setItem(context, "switchOnBoardsList", [])
        contextUtil.setItem(context, "switchOffBoardsList",
                            switch_on_boards_list)
        scale_out_intf_module_dict = {}
        for board in boards_list:
            scale_out_intf_module_list = adTlvUtil.getScaleOutIntfModuleList(
                tlv, board, product_model=product_model,
                net_working_type=net_working_type, logger=logger)
            key = board["enclosureSN"]
            if key in scale_out_intf_module_dict:
                new_scale_out_intf_module_list = scale_out_intf_module_dict\
                    .get(key)
                new_scale_out_intf_module_list.extend(
                    scale_out_intf_module_list)
                scale_out_intf_module_dict[key] = \
                    new_scale_out_intf_module_list
            else:
                scale_out_intf_module_dict[key] = scale_out_intf_module_list
        logger.logInfo("scaleOutIntfModuleDict:%s" %
                       scale_out_intf_module_dict)

        enclosure_sns = scale_out_intf_module_dict.keys()
        is_pass = True  # 检查是否通过
        all_err_msg = list()  # 所有错误信息汇总
        all_sugg = list()  # 所有建议汇总

        # 检查接口卡数量是否正确
        for enclosureSN in enclosure_sns:
            pass_flag, err_msg, sugg = check_intf_module_num(
                scale_out_intf_module_dict, enclosureSN, boards_list,
                expansion_spec, lang, logger)

            if not pass_flag:
                is_pass = False
                all_err_msg.append(err_msg)
                all_sugg.append(sugg)

        if not is_pass:
            result_dict["flag"] = False
            result_dict["errMsg"], result_dict["suggestion"] = \
                "\n".join(all_err_msg), all_sugg[0]
            contextUtil.handleFailure(context, result_dict)
            return

        # 检查接口卡健康状态
        for enclosureSN in enclosure_sns:
            pass_flag, err_msg_list, sugg_list = check_intf_module_health(
                scale_out_intf_module_dict, enclosureSN, logger, lang)

            if not pass_flag:
                is_pass = False
                all_err_msg.extend(err_msg_list)
                all_sugg.extend(sugg_list)

        if not is_pass:
            result_dict["flag"] = False
            result_dict["errMsg"], result_dict["suggestion"] = \
                "\n".join(all_err_msg), all_sugg[0]
            contextUtil.handleFailure(context, result_dict)
            return

        # 检查接口卡状态
        for enclosureSN in enclosure_sns:
            pass_flag, err_msg_list, sugg_list = check_intf_module_status(
                scale_out_intf_module_dict, enclosureSN, logger, lang)

            if not pass_flag:
                is_pass = False
                all_err_msg.extend(err_msg_list)
                all_sugg.extend(sugg_list)

        if not is_pass:
            result_dict["flag"] = False
            result_dict["errMsg"], result_dict["suggestion"] = \
                "\n".join(all_err_msg), all_sugg[0]
            contextUtil.handleFailure(context, result_dict)
            return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def check_intf_module_num(scale_out_intf_module_dict, enclosureSN, boards_list,
                          expansion_spec, lang, logger):
    """检查接口卡数量，涉及到检查C卡C+卡"""
    is_pass = True
    err_msg, sugg = "", ""
    scale_out_intf_modules = scale_out_intf_module_dict.get(enclosureSN)
    logger.logInfo("scaleOutIntfModules=" +
                   str(scale_out_intf_modules))
    current_scale_out_intf_module_num = len(scale_out_intf_modules)
    enclosure_nodes = common.getClusterNodes(enclosureSN, boards_list)
    scale_out_card_spec_num = common.getScaleOutCardSpecNum(
        expansion_spec)
    logger.logInfo("enclosureNodes=" + str(enclosure_nodes))
    required_scale_out_intf_module_num = \
        enclosure_nodes * scale_out_card_spec_num

    if current_scale_out_intf_module_num < \
            required_scale_out_intf_module_num:
        logger.logNoPass(
            "Interface Modules are insufficeint(enclosureSN:%s, "
            "currentSNum:%s, requiredNum:%s)" %
            (enclosureSN, current_scale_out_intf_module_num,
             required_scale_out_intf_module_num))
        is_pass = False
        err_msg, sugg = common.getMsg(lang,
                                      "interface.modules.insufficeint",
                                      (enclosureSN,
                                       current_scale_out_intf_module_num,
                                       required_scale_out_intf_module_num))

    return is_pass, err_msg, sugg


def check_intf_module_health(scale_out_intf_module_dict, enclosureSN, logger,
                             lang):
    """检查接口模块健康情况是否正常"""
    is_pass = True
    err_msg_list = list()
    sugg_list = list()
    scale_out_intf_modules = scale_out_intf_module_dict.get(
        enclosureSN)
    for scale_out_intf_module in scale_out_intf_modules:
        intf_module_location = scale_out_intf_module["location"]

        # 检查健康状态是否正常
        health_status = scale_out_intf_module["healthStatus"]
        if health_status != tlvData.HEALTH_STATUS_E['NORMAL']:
            logger.logNoPass(
                "The health status of interface module "
                "(enclosure SN: %s; ID: %s) is abnormal (Health Status:%s)." %
                (enclosureSN, intf_module_location, health_status))
            is_pass = False
            err_msg, sugg = common.getMsg(lang,
                                          "dorado.interface.modules."
                                          "health.status.abnormal",
                                          (enclosureSN, intf_module_location))
            err_msg_list.append(err_msg)
            sugg_list.append(sugg)

    return is_pass, err_msg_list, sugg_list


def check_intf_module_status(scale_out_intf_module_dict, enclosureSN, logger,
                             lang):
    # 检查运行状态是否正常
    is_pass = True
    err_msg_list = list()
    sugg_list = list()
    scale_out_intf_modules = scale_out_intf_module_dict.get(
        enclosureSN)
    for scale_out_intf_module in scale_out_intf_modules:
        intf_module_location = scale_out_intf_module["location"]
        running_status = scale_out_intf_module["runningStatus"]
        if running_status != tlvData.RUNNING_STATUS_E['RUNNING']:
            logger.logNoPass(
                "The running status of interface module (enclosure SN: %s; ID:"
                " %s) is abnormal (Running Status:%s)." %
                (enclosureSN, intf_module_location, running_status))
            is_pass = False
            err_msg, sugg = common.getMsg(lang,
                                          "interface.modules.running."
                                          "status.abnormal",
                                          (enclosureSN, intf_module_location))
            err_msg_list.append(err_msg)
            sugg_list.append(sugg)

    return is_pass, err_msg_list, sugg_list
