# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import adTlvUtil
from cbb.frame.tlv import tlvData
from cbb.business.operate.expansion import FuncFactory


@FuncFactory.handleFailureForRetry
def execute(context):
    '''
    @summary: 检查所有控制器内存规格一致
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        #获取内存规格信息
        memoryInfoDict = {}
        boardsList = contextUtil.getItem(context, "boardsList")
        for board in boardsList:
            allMemoryList = adTlvUtil.getAllMemory(tlv, board)
            logger.logInfo("allMemoryList:%s, board:%s" % (allMemoryList, board))
            for memoryInfo in allMemoryList:
                enclosureSN = board["enclosureSN"]
                controllerId = memoryInfo["ctrlId"]
                capacity = memoryInfo["memorySize"]
                
                key = (enclosureSN, controllerId)
                if key not in memoryInfoDict:
                    memoryInfoDict[key] = capacity
        
        #检查内存规格
        memSpecSet = set(memoryInfoDict.values())
        if len(memSpecSet) != 1:
            err_info = []
            parsed_sns = []
            for sn_ctrl_id, cap in memoryInfoDict.items():
                sn = sn_ctrl_id[0]
                if sn not in parsed_sns:
                    err_info.append('\n(SN: %s): %.3fGB' % (sn, cap / 1024))
                    parsed_sns.append(sn)
            logger.logInfo("err_info:%s" % str(err_info))
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(
                lang, "check.memory.failure",
                ",".join(err_info))
            contextUtil.handleFailure(context, resultDict)
            return
            
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
