# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import adTlvUtil

#进度总剩余时间
LIMIT_TIME = 60
#进度刷新间隔
INTERVAL = 2

def execute(context):
    '''
    @summary: 检查待扩容控制器CPU利用率
    '''
    
    try:
        #进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        #进度开始
        common.inProcess(context)
        
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        #检查待扩容控制器CPU利用率
        newBoardsList = contextUtil.getItem(context, "newBoardsList")
        for board in newBoardsList:
            cpuUsageList = adTlvUtil.getAllCpuUsage(tlv, board)
            logger.logInfo("cpuUsageList:%s" % cpuUsageList)
            enclosureSN = board["enclosureSN"]
            for cpuUsageInfo in cpuUsageList:
                cpuUsage = cpuUsageInfo["cpuUsage"]
                if not cpuUsage.isdigit():
                    logger.logNoPass("Get CPU usage failure(cpuUsage:%s, board:%s)" % 
                     (cpuUsage, board))
                    resultDict["flag"] = False
                    resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "new.get.cpu.usage.failure", enclosureSN)
                    contextUtil.handleFailure(context, resultDict)
                    return
                if int(cpuUsage) > common.MAX_CPU_USAGE:
                    logger.logNoPass("The controller CPU usage is higher than %s(cpuUsage:%s, board:%s)" % 
                     (common.MAX_CPU_USAGE, cpuUsage, board))
                    resultDict["flag"] = False
                    resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "new.cpu.usage.check.failure", 
                     (enclosureSN, "%s%s" % (common.MAX_CPU_USAGE, "%")))
                    contextUtil.handleFailure(context, resultDict)
                    return
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        #进度条刷为完成状态
        common.finishProcess(context)
