# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.expansion import FuncFactory


@FuncFactory.handleFailureForRetry
def execute(context):
    '''
    @summary: 检查待扩容控制器状态
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        newBoardsList = contextUtil.getItem(context, "newBoardsList")

        for board in newBoardsList:
            controllerStatus = adTlvUtil.checkControllerStatus(tlv, board)
            if controllerStatus[0] != True:
                
                logger.logNoPass("status of new controllers are abnormal(%s)" % (str(board)))
                abnormalCtrlsStr = ",".join(controllerStatus[1])
                resultDict["flag"] = False
                resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "new.ctrls.status.abnormal",(board["enclosureSN"],abnormalCtrlsStr))
                contextUtil.handleFailure(context, resultDict)
                return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
