# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import FuncFactory
from cbb.frame.base import baseUtil
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil


@FuncFactory.handleFailureForRetry
def execute(context):
    """检查是否存在相同硬盘框SN

    :param context:
    :return:
    """
    try:
        resultDict = {"flag": True, "errMsg": "", "suggestion": ""}
        logger = common.getLogger(context.get("logger"), __file__)

        cli = contextUtil.getCli(context)
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        productModel = contextUtil.getItem(context, "productModel", "")
        flag, originEncInfo = getOriginEncs(cli, lang, productModel)
        if not flag:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "get.origin.eng.enc.failed")
            contextUtil.handleFailure(context, resultDict)
            return

        logger.logInfo("get originEncInfo is %s" % originEncInfo)
        errorEncInfo = []
        boardsList = contextUtil.getItem(context, "newBoardsList")
        for board in boardsList:
            enclosureList = adTlvUtil.getDisEnclosureList(tlv, board)
            logger.logInfo("get disk enclosure(%s) on the eng(sn:%s)" % (str(enclosureList), board.get("enclosureSN")))
            for enc in enclosureList:
                macAd = enc.get("macAddress")
                name = enc.get("name")
                temMac = macAd.replace(":", "").lstrip("0")
                macAd = "0x%s" % temMac
                if macAd in originEncInfo:
                    errorEncInfo.append((name, board.get("enclosureSN")))

        logger.logInfo("get err enclosure is %s" % errorEncInfo)
        if len(errorEncInfo):
            errEncMsg = ""
            for errEnc in errorEncInfo:
                msg, __ = common.getMsg(lang, "duplicate.disk.enclosure.single", errEnc)
                errEncMsg += msg

            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "duplicate.disk.enclosure.mac",
                                                                           suggestionArgs=errEncMsg)
            contextUtil.handleFailure(context, resultDict)
            return
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def getOriginEncs(cli, lang, productModel):
    """获取原阵列的框的SN

    :param cli: cli对象
    :param lang: 语言
    :param productModel: 产品型号
    :return:
    """
    encInfo = []
    if baseUtil.isArmDevV5New(productModel):
        # V5新硬件命令变更
        cmd = "eam showframe -devm"
        flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, True, lang)
    else:
        cmd = "eam showframe"
        flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModelAndAttach(cli, cmd, True, lang)
    if not flag:
        return False, encInfo

    enclines = cliRet.encode("utf8").splitlines()
    for encline in enclines:
        if "=" not in encline:
            continue

        lines = encline.splitlines()
        for line in lines:
            info = line.split("=")
            if len(info) < 2:
                continue

            tmp = info[0].strip().lower()
            if str(tmp) == "mac":
                ad = info[1].strip().split(" ")[0].strip()
                encInfo.append(ad)

    return True, encInfo
