# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.frame.tlv import adTlvUtil
from cbb.frame.context import contextUtil

def execute(context):
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        spcVersion = contextUtil.getItem(context, "spcVersion")
        if spcVersion not in config.NLSAS_UNMATCH_PRODUCT_VERSION:
            contextUtil.handleSuccess(context)
            return
        
        newBoardsList = contextUtil.getItem(context, "newBoardsList")
        nlsasDiskList = []
        for board in newBoardsList:
            isExistHighDenEnc,highDensityEncList = adTlvUtil.isExistHighDensityEnc(context, board)
            if not isExistHighDenEnc:
                continue
                
            diskRecs = adTlvUtil.getDiskRecords(tlv, board)
            nlsasDiskList += common.getUnmatchCompliance10TNlsasDisk(context, highDensityEncList, diskRecs)
        nlsasDiskList = list(set(nlsasDiskList))
        nlsasDiskList.sort()
        
        if len(nlsasDiskList) > 0:
            resultDict["flag"] = False
            resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "check.newEnc.disk.capacity.over.stantard", ",".join(nlsasDiskList))
            contextUtil.handleFailure(context, resultDict)
            return
            
        contextUtil.handleSuccess(context)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return