# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.expansion import FuncFactory


@FuncFactory.handleFailureForRetry
def execute(context):
    '''
    @summary: 检查待扩容控制器IBC公私钥对是否为默认值
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        #检查待扩容控制器IBC公私钥对是否为默认值
        newBoardsList = contextUtil.getItem(context, "newBoardsList")
        for board in newBoardsList:
            iBCKeyPairChanged = adTlvUtil.isIBCKeyPairChanged(tlv, board)
            if iBCKeyPairChanged == 1:
                logger.logNoPass("new controllers IBC key pair changed(%s)" % (str(board)))
                resultDict["flag"] = False
                resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "new.ctrls.ibc.keyPair.changed", board["enclosureSN"])
                contextUtil.handleFailure(context, resultDict)
                return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
