# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import adTlvUtil

def execute(context):
    '''
    @summary: 检查待扩容控制器产品型号
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        
        newBoardsList = contextUtil.getItem(context, "newBoardsList")
        productModel = contextUtil.getItem(context, "productModel")
        for board in newBoardsList:
            pdtModel = adTlvUtil.getProductModel(tlv, board)
            if pdtModel is None:
                continue
            if pdtModel != productModel:
                logger.logNoPass("product model inconsistent(%s)" % str(board))
                resultDict["flag"] = False
                resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "pdt.model.inconsistent", board["enclosureSN"])
                contextUtil.handleFailure(context, resultDict)
                return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
