# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.expansion import FuncFactory
from cbb.common.conf.productConfig import compare_dorado_version, DORADO_NAS

@FuncFactory.handleFailureForRetry
def execute(context):
    '''
    @summary: 检查待扩容引擎告警
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        preCheckAlarmWhiteList = list(common.PRE_CHECK_ALARM_WHITELIST)
        dorado_nas_cmp = compare_dorado_version(
            contextUtil.getCurVersion(context), DORADO_NAS)
        is_dorado_nas = dorado_nas_cmp[0] and dorado_nas_cmp[1]
        if is_dorado_nas:
            preCheckAlarmWhiteList.extend(
                common.PRE_CHECK_NEW_SYS_ALARM_WHITELIST_FOR_DORADO_NAS)
        else:
            preCheckAlarmWhiteList.extend(
                common.PRE_CHECK_NEW_SYS_ALARM_WHITELIST)
        newBoardsList = contextUtil.getItem(context, "newBoardsList")
        for board in newBoardsList:
            alarmList = adTlvUtil.get_important_and_urgent_alarms(tlv, board)
            logger.logInfo("alarmList:%s, board:%s" % (alarmList, board))
            for line in alarmList:
                if line["CMO_ALARM_CLEAR_TIME"] != 0:
                    continue
                if line["CMO_ALARM_RECOVERY_TIME"] != 0:
                    continue
                if line["CMO_ALARM_LEVEL"] in [5, 6] and line["CMO_ALARM_ID"] not in preCheckAlarmWhiteList:
                    logger.logNoPass("new controllers exist alarms(%s)" % board)
                    logger.logNoPass("alarmInfo:%s, board:%s" % (line, board))
                    resultDict["flag"] = False
                    resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "new.ctrls.exists.alarm", board["enclosureSN"])
                    contextUtil.handleFailure(context, resultDict)
                    return
            
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
