﻿# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.frame.tlv import adTlvUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config

#进度总剩余时间
LIMIT_TIME = 60
#进度刷新间隔
INTERVAL = 2

def execute(context):
    '''
    @summary: 重启待扩容控制器
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        
        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)
        context["remindInfo"] = common.getDangerNoticeRemindInfo(lang)
        dialogUtil = context['dialogUtil']
        
        msg = common.getMsg(lang, "check.clear.expansion.confirm.prompt")[0]
        rec = dialogUtil.showWarningDialog(msg)
        if not rec:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "clear.config.termination")
            contextUtil.handleFailure(context, resultDict)
            return
        
        #进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        #进度开始
        common.inProcess(context)
        
        newBoardsList = contextUtil.getItem(context, "newBoardsList")
        
        #所有的新引擎所在框SN集合
        newEnclosuresList = common.getNewEnclosuresList(newBoardsList)
        
        for newEnclosure in newEnclosuresList:
            #逐框清除配置
            for board in newBoardsList:
                if board["enclosureSN"] != newEnclosure:
                    continue
                try:
                    clearConfigRecord = adTlvUtil.clearConfig(tlv, board)
                    logger.logInfo("clearConfigRecord:%s" % clearConfigRecord)
                except Exception as exception:
                    logger.logNoPass("clear config failure(node info:%s)" % str(board))
                    logger.logException(exception)
                    
                    expArgs = exception.args
                    if expArgs is not None and len(expArgs) == 2:
                        errCode = str(expArgs[0]).strip()
                        #设备未连接
                        if errCode == config.BDM_CLEAR_DISK_DLT_ERROR:
                            resultDict["flag"] = False
                            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "expansion.clearconfig.disk.failure", newEnclosure)
                            contextUtil.handleFailure(context, resultDict)
                            return
                        
                    resultDict["flag"] = False
                    resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "expansion.clearconfig.failure", newEnclosure)
                    contextUtil.handleFailure(context, resultDict)
                    return
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
        
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        context["remindInfo"] = ""
        #进度条刷为完成状态
        common.finishProcess(context)
