# -*- coding: UTF-8 -*-

from cbb.frame.tlv import adTlvUtil
from cbb.frame.context import contextUtil
from cbb.frame.base import baseUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
import time
import threading

CHECK_POWERON_LIMIT_TIME = 540
OTHER_EXECUTE_COMMAND = 60
CHECK_POWERON_INTEVAL_TIME = 30
UPGRADE_PROCESS_INTEVAL_TIME = 10

def execute(context):
    '''
    @summary: 获取当前集群和待扩容控制器节点信息
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)

        tlv = contextUtil.getTlv(context)
        lang = contextUtil.getLang(context)

        # 进度条刷新
        event = threading.Event()
        context["event"] = event
        t = threading.Thread(target=updateProcess, args=(context,))
        t.start()
        #初始化进度条标识，注意每个return前都要刷新退出标识，否则进度条进程死循环
        context["checkState"] = config.PROCESS_STATE_CHECKING
        
        originEnclosureSNs = contextUtil.getItem(context, "originEnclosureSNs")
        newConfigCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
        ctrlNum = contextUtil.getItem(context, "ctrlNum")
        productModel = contextUtil.getItem(context, "productModel")
        
        isDorado = False
        if common.isDorado(productModel):
            isDorado = True
        
        #启动AD
        startedADNum = adTlvUtil.startAD(tlv)
        logger.logInfo("startedADNum is = " + str(startedADNum))
        if startedADNum < ctrlNum:
            contextUtil.setItem(context, "isADStarted", False)
            logger.logNoPass("start AD failure(startedADNum:%s, ctrlNum:%s)" % (startedADNum, ctrlNum))
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "start.ad.failure")
            contextUtil.handleFailure(context, resultDict)
            finishProcess(context)
            return 
        contextUtil.setItem(context, "isADStarted", True)
        logger.logInfo("AD started")
        
        requiredExpansionCtrlsNum = newConfigCtrlNum - ctrlNum
        startTime = time.clock()
        while True:  
            tlv = contextUtil.getTlv(context)
            currentExpansionCtrlsNum = 0    #初始化扫描到节点数
            #下发是否扩容配置
            notifyADRet = adTlvUtil.notifyAD(tlv)
            if notifyADRet == 0:
                logger.logNoPass("notify AD failure")
                if (time.clock() - startTime) <= CHECK_POWERON_LIMIT_TIME:
                    baseUtil.safeSleep(CHECK_POWERON_INTEVAL_TIME)
                    continue
                logger.logNoPass("notify AD timeout")
                msg = "num.new.ctrls.less"
                if isDorado:
                    msg = "dorado.num.new.ctrls.less"
                resultDict["flag"] = False
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, msg, 
                   (currentExpansionCtrlsNum, requiredExpansionCtrlsNum))
                contextUtil.handleFailure(context, resultDict)
                finishProcess(context)
                return 
            logger.logInfo("AD notified")
            
            #查询框和节点
            orginBoardsList = adTlvUtil.getBoards(tlv)
            oldBoardsList = []
            newExpansionBoardsList = []
            newExpansionEncolsureSNList = []
            for board in orginBoardsList:
                enclosureSN = board["enclosureSN"]
                if enclosureSN in originEnclosureSNs:
                    oldBoardsList.append(board.copy())
                else:
                    newExpansionBoardsList.append(board.copy())
                    if enclosureSN not in newExpansionEncolsureSNList:
                        newExpansionEncolsureSNList.append(enclosureSN)
            
            oldBoardsList.sort(lambda x,y:common.cmpBoard(x,y))
            newExpansionBoardsList.sort(lambda x,y:common.cmpBoard(x,y))
            boardsList = oldBoardsList + newExpansionBoardsList
            currentExpansionCtrlsNum = len(newExpansionBoardsList)
            
            logger.logInfo("orginBoardsList:%s" % orginBoardsList)
            logger.logInfo("boardsList:%s" % boardsList)
            logger.logInfo("oldBoardsList:%s" % oldBoardsList)
            logger.logInfo("newExpansionBoardsList:%s" % newExpansionBoardsList)
            logger.logInfo("newExpansionEncolsureSNList:%s" % newExpansionEncolsureSNList)
            logger.logInfo("currentExpansionCtrlsNum:%s" % currentExpansionCtrlsNum)
            logger.logInfo("requiredExpansionCtrlsNum:%s" % requiredExpansionCtrlsNum)
            
            if currentExpansionCtrlsNum >= requiredExpansionCtrlsNum:
                logger.logInfo("Power on success. Get boards success.")
                break
            elif currentExpansionCtrlsNum != 0:
                for board in newExpansionBoardsList:
                    logger.logInfo("Checking expansion controller status : %s"%str(board))
                    controllerStatus = adTlvUtil.checkControllerStatus(tlv, board)
                    if controllerStatus[0] != True:                    
                        logger.logNoPass("status of new controllers are abnormal(%s)" % (str(board)))
                        abnormalCtrlsStr = ",".join(controllerStatus[1])
                        resultDict["flag"] = False
                        resultDict["errMsg"],resultDict["suggestion"] = common.getMsg(lang, "new.ctrls.status.abnormal",(board["enclosureSN"],abnormalCtrlsStr))
                        contextUtil.handleFailure(context, resultDict)
                        finishProcess(context)
                        return
                        
            if (time.clock() - startTime) > CHECK_POWERON_LIMIT_TIME:
                msg = "dorado.num.new.ctrls.less"
                resultDict["flag"] = False
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, msg, 
                   (currentExpansionCtrlsNum, requiredExpansionCtrlsNum))
                contextUtil.handleFailure(context, resultDict)
                finishProcess(context)
                return
            
            baseUtil.safeSleep(CHECK_POWERON_INTEVAL_TIME)
        
        contextUtil.setItem(context, "orginBoardsList", orginBoardsList)
        contextUtil.setItem(context, "oldBoardsList", oldBoardsList)
        contextUtil.setItem(context, "boardsList", boardsList)
        contextUtil.setItem(context, "newExpansionBoardsList", newExpansionBoardsList)
        contextUtil.setItem(context, "newExpansionEncolsureSNList", newExpansionEncolsureSNList)
        
        adTlvUtil.refreshRouteInfo(tlv, logger)
        
        contextUtil.handleSuccess(context)
        logger.logPass()
        finishProcess(context)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        finishProcess(context)
        return

def updateProcess(context):
    logger = common.getLogger(context.get("logger"), __file__)
    #剩余时间总数
    totleTime = CHECK_POWERON_LIMIT_TIME + OTHER_EXECUTE_COMMAND
    totalReaminTime = totleTime
    common.showUI(context, 0, totalReaminTime)
    
    while context["checkState"] == config.PROCESS_STATE_CHECKING:
        #更新进度条
        totalReaminTime -= UPGRADE_PROCESS_INTEVAL_TIME
        if  totalReaminTime <= 0:
            common.showUI(context, 100, 0)
            return
        
        currentPro = int(100*(totleTime - totalReaminTime)/totleTime)
        logger.logInfo("[UI_thread]totalReaminTime:%s currentPro : %s" % (str(totalReaminTime),str(currentPro)))
        common.showUI(context, currentPro, totalReaminTime)
        
        baseUtil.safeSleep(UPGRADE_PROCESS_INTEVAL_TIME)
    
    common.showUI(context, 100, 0)
    return


def finishProcess(context):
    context["checkState"] = config.PROCESS_UPGRADE_FINISHED
    common.showUI(context, 100, 0)
    event = context.get('event')
    if event:
        event.set()
    return