# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

def getItems(context):
    '''
    @summary: 获取更换线缆提示项，需要配置交换机时，显示配置交换机提示项
    '''
    
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        newConfigClustType = contextUtil.getItem(context, "newConfigClustType")
        configClustType = contextUtil.getItem(context, "configClustType")
        lang = contextUtil.getLang(context)
        
        makesureItems = []
        makesureItems.append(contextUtil.getResource(context, "replacingPlane.makesure"))
        if common.needConfigSwitch(newConfigClustType, configClustType): 
            makesureItems.append(common.getRes(lang, "replacingPlane_initSwitchMakesure"))
            makesureItems.append(common.getRes(lang, "replacingPlane_manuallyConfigSwitchMakesure"))
        
        jsonArray = []
        for item in makesureItems:
            jsonArray.append('{"title":"%s"}' % item)
        context["retData"] = "[%s]" % ",".join(jsonArray)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
       
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return

def confirm(context):
    newConfigClustType = contextUtil.getItem(context, "newConfigClustType")
    configClustType = contextUtil.getItem(context, "configClustType")
    
    #弹出生成配置交换机的窗口
    if common.needConfigSwitch(newConfigClustType, configClustType):
        common.popupConfigSwtichDialog(context)
    return
